//
//  APObject.h
//  APlayer
//
//  Created by Holger Sadewasser on 4/25/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef enum APObjectTypes {
  cEmpty     = 0,
  cShip      = 1,
  cSaucer    = 2,
  cShot      = 3,
  cAsteroid1 = 4,
  cAsteroid2 = 5,
  cAsteroid3 = 6,
  cAsteroid4 = 7,
  cExplosion = 8
} APObjectTypes_t;


@interface APObject : NSObject <NSCoding> {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------
  
  @public

  int mID;
  APObjectTypes_t mType; 
  int mSize;

  int mInitPosX;
  int mInitPosY;
  int mTempPosX;
  int mTempPosY;
  
  int mDeltaX[9];
  int mDeltaY[9];

  int mPosXInt;
  int mPosYInt;
  double mPosX;
  double mPosY;
  double mCorrX;
  double mCorrY;

  double mHeadingX;
  double mHeadingY;
  BOOL mFlgCalcHeading;
  
  BOOL mFlgTagged;

//- Begin Records shot angles ---------------------
//  BOOL mFlgRecording;
//  double mShipViewX;
//  double mShipViewY;
//  uint8_t mPing;
//  uint8_t mAngleByteTmp;
//- End Records shot angles ---------------------    

  double mRadius;
  double mRadius2;
  double mRadiusC;
  double mRadiusC2;
  double mBBx1;
  double mBBy1;
  double mBBx2;
  double mBBy2;

  unsigned int mInitFrame;
  unsigned int mTempFrame;
  unsigned int mTotalFrames;
  int mTimeToLive;
  BOOL mFlgTargeted;
  
  BOOL mFlgOwnShot;
  unsigned int mNumberOfShots;
  
  unsigned int mNextAdaption;
  
  BOOL mFlgHyperspace;
  
#ifdef INTERSECTION_TEST
  double mQ;
  double mC;
#endif
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)initWithType:(int)iType size:(int)iSize posX:(int)iPosX posY:(int)iPosY;
-(id)initWithType:(int)iType posX:(int)iPosX posY:(int)iPosY;
-(id)initWithType:(int)iType;
-(id)init;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(NSComparisonResult)compareTimeToLiveDescendingToObject:(APObject *)iObject;
-(BOOL)matchesObjectWithType:(APObjectTypes_t)iType size:(int)iSize posX:(int)iPosX posY:(int)iPosY atDistance:(double *)eDist;
-(void)updateWithPosX:(int)iPosX posY:(int)iPosY frames:(uint8_t)iFrames;
-(void)moveByFrames:(NSNumber *)iFrames;
-(double)timeOfCollisionWithPosX:(double)iPosX posY:(double)iPosY dirX:(double)iDirX dirY:(double)iDirY radius:(double)iRadius delay:(int)iDelay headingStable:(BOOL)iFlgHeadingStable accuracy:(double *)xAccuracy;
-(void)setTimeToLive:(int)iTimeToLive;
-(int)timeToLive;
-(void)setTargeted:(BOOL)iFlgTargeted;
-(BOOL)targeted;
-(unsigned int)totalFrames;
-(int)ID;
-(APObjectTypes_t)type;
-(int)size;
-(double)posX;
-(double)posY;
-(int)posXInt;
-(int)posYInt;
-(BOOL)calculatingHeading;
-(double)headingX;
-(double)headingY;
-(double)radius;
-(double)radiusC;
-(unsigned int)frames;
-(BOOL)isAtPosX:(int)iPosX posY:(int)iPosY;
-(void)makeExplosion;
-(void)decreaseTimeToLiveBy:(NSNumber *)iFrames;
-(void)setOwnShot:(BOOL)iFlgOwnShot;
-(BOOL)isOwnShot;
-(BOOL)allowsHyperspace;
-(unsigned)numberOfShots;
-(void)tag;
-(void)untag;
-(BOOL)isTagged;

#if defined WITH_WINDOW || defined INTERSECTION_TEST
-(void)draw;
#endif

-(void)_setPosX:(int)iPosX posY:(int)iPosY;


@end
