//
//  APProphet.m
//  APlayer
//
//  Created by Holger Sadewasser on 5/8/08.
//  Copyright 2008. All rights reserved.
//

#import "parameter.h"
#import "APProphet.h"
#import "APTarget.h"


typedef struct TargetStruct {
  APTarget * target;
  double accuracy;
} TargetStruct_t;


extern BOOL gFlgLogging;


// methods that are used internally by this class, but should not be needed externally
// are defined here to keep them "private". Anyone who knows about them can still call
// them of course, but by putting the prototypes here, it emphasizes that they are only
// meant for internal use.
@interface APProphet(_private_methods)

-(BOOL)_computeHitsFromTracker:(APTracker *)iTracker ship:(APShip *)iShip startAngle:(uint8_t)iAngleOffs numberOfAngles:(int)iNumAngles
              rotation:(int)iRotDirection frameOffs:(int)iFrameOffs frames:(int)iFramesOfLevel into:(NSMutableArray *)xListOfTargets;
@end


@implementation APProphet

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(NSMutableArray *)hitsFromTracker:(APTracker *)iTracker ship:(APShip *)iShip frames:(int)iFramesOfLevel maxOffset:(int)iMaxOffset {
  
  NSMutableArray * listOfTargets1 = [[NSMutableArray alloc] initWithCapacity:40];
  NSMutableArray * listOfTargets2 = [[NSMutableArray alloc] initWithCapacity:40];
  BOOL flgChecked;
  int i;
  
  flgChecked  = [self _computeHitsFromTracker:iTracker ship:iShip startAngle:0 numberOfAngles:43 rotation:1 frameOffs:0 frames:iFramesOfLevel into:listOfTargets1];
  flgChecked |= [self _computeHitsFromTracker:iTracker ship:iShip startAngle:1 numberOfAngles:43 rotation:-1 frameOffs:0 frames:iFramesOfLevel into:listOfTargets2];
  
  [listOfTargets1 addObjectsFromArray:listOfTargets2];
  
  for ( i = 1; i <= iMaxOffset; i++ ) {
    [listOfTargets2 removeAllObjects];
    flgChecked |= [self _computeHitsFromTracker:iTracker ship:iShip startAngle:0 numberOfAngles:43-i rotation:1 frameOffs:i frames:iFramesOfLevel into:listOfTargets2];
    [listOfTargets1 addObjectsFromArray:listOfTargets2];
    [listOfTargets2 removeAllObjects];
    flgChecked |= [self _computeHitsFromTracker:iTracker ship:iShip startAngle:1 numberOfAngles:43-i rotation:-1 frameOffs:i frames:iFramesOfLevel into:listOfTargets2];
    [listOfTargets1 addObjectsFromArray:listOfTargets2];
  }
//  [listOfTargets2 removeAllObjects];
////  flgChecked |= [self _computeHitsFromTracker:iTracker ship:iShip startAngle:0 numberOfAngles:1 rotation:0 frameOffs:1 frames:iFramesOfLevel into:listOfTargets2];
//  flgChecked |= [self _computeHitsFromTracker:iTracker ship:iShip startAngle:0 numberOfAngles:42 rotation:1 frameOffs:1 frames:iFramesOfLevel into:listOfTargets2];
//  [listOfTargets1 addObjectsFromArray:listOfTargets2];

  //  [listOfTargets2 removeAllObjects];
//  flgChecked |= [self _computeHitsFromTracker:iTracker ship:iShip startAngle:0 numberOfAngles:1 rotation:0 frameOffs:1 frames:iFramesOfLevel into:listOfTargets2];
//  [listOfTargets1 addObjectsFromArray:listOfTargets2];

  [listOfTargets2 release];
  
//  if ( flgChecked == YES && [listOfTargets1 count] == 0 ) {
//    NSLog(@"no targets found");
//    [iTracker createSnapshot];
//  }
  
  return [listOfTargets1 autorelease];
}


-(NSMutableArray *)collisionsFromTracker:(APTracker *)iTracker frames:(int)iFramesOfLevel {

  NSEnumerator * enumerator = [[iTracker objects] objectEnumerator];
  NSMutableArray * targets = [[NSMutableArray alloc] initWithCapacity:40];
  APObject * object;
  APShip * ship = [iTracker ship];
  double timeOfCollision;
  APTarget * target;
  
  while( (object = [enumerator nextObject]) ) {
    if ( [object type] != cShip && [object allowsHyperspace] == YES ) {
      timeOfCollision = [ship timeOfCollisionWithPosX:[object posX]
                                                 posY:[object posY]
                                                 dirX:[object headingX]
                                                 dirY:[object headingY]
                                               radius:[object radiusC]
                                        headingStable:(iFramesOfLevel >= FRAMES_TO_STABILIZE || [object calculatingHeading] == NO)];
      if ( timeOfCollision >= 0.0 ) {
        target = [[APTarget alloc] initWithAngleByte:0
                                           direction:0
                                         frameOfShot:0
                                             waiting:0
                                              object:object
                                          timeToShot:0
                                      durationOfShot:timeOfCollision];
        [targets addObject:target];
      }
    }
  }
  
  return [targets autorelease];
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Private Methods
// -------------------------------------------------------------------------------------

-(BOOL)_computeHitsFromTracker:(APTracker *)iTracker ship:(APShip *)iShip startAngle:(uint8_t)iAngleOffs numberOfAngles:(int)iNumAngles
              rotation:(int)iRotDirection frameOffs:(int)iFrameOffs frames:(int)iFramesOfLevel into:(NSMutableArray *)xListOfTargets {
  
//  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
  int angleCount;
  int objCount;
  int numObjects = [iTracker->mObjects count];
  uint8_t angleByte;
  APShip * ship = iTracker->mShip;
  double shipX;
  double shipY;
  double shotX;
  double shotY;
//  double angle;
//  double sina, cosa;
  double timeOfCollision;
  APTarget * target;
  APObject * object;
  double accuracy;
  TargetStruct_t targets[40];
  APAngleStruct_t * angles;
  int delay;
  
  BOOL flgChecked = NO;
  
  bzero( &targets, sizeof(targets) );

  if ( iShip != nil )
    ship = iShip;
  else
    ship = [iTracker ship];

//  APAngleStruct_t *angles = [ship angles];
  
  angleByte = ship->mAngleByte + (uint8_t)(iRotDirection * iAngleOffs);

  if ( gFlgLogging == YES ) {
    NSLog(@"cur angle byte: %4d  sa: %4d  dir: %d  ofs: %d", ship->mAngleByte, angleByte, iRotDirection, iAngleOffs);
  }
  
  angles = [ship angles];
  shipX = [ship posX];
  shipY = [ship posY];
  
  for (angleCount = 0; angleCount < iNumAngles; angleCount++) {
//    angle = (double)angleByte * 3.0 * M_PI / 128.0;
//    sina = round(127.0*sin(angle));
//    cosa = round(127.0*cos(angle));
//    shotX = shipX + (floor(cosa/2.0) + floor(cosa/4.0))/8.0;
//    shotY = shipY + (floor(sina/2.0) + floor(sina/4.0))/8.0;

//    shotX = ship->mPosX - 0.5 + 19.5 * cos(angle);
//    shotY = ship->mPosY - 0.5 + 19.5 * sin(angle);
//    shotX = (ship->mPosX * 8.0 + 95 * cos(angle))/8.0;
//    shotY = (ship->mPosY * 8.0 + 95 * sin(angle))/8.0;
    
    shotX = shipX + angles[angleByte].startX;
    shotY = shipY + angles[angleByte].startY;
    delay = angleCount + (int)iAngleOffs+1+iFrameOffs;    // This works only with no latency
    
    for (objCount = 0; objCount < numObjects; objCount++) {
      object = [iTracker->mObjects objectAtIndex:objCount];
      if ( [object type] != cShot && [object type] != cShip && [object timeToLive] < 0 && [object isTagged] == NO ) {
//      if ( [object type] != cShot && [object type] != cShip ) {
        flgChecked = YES;
        timeOfCollision = [object timeOfCollisionWithPosX:shotX
                                                     posY:shotY
//                                                     dirX:(double)(ship->mAngles[angleByte].intX)/8.0
//                                                     dirY:(double)(ship->mAngles[angleByte].intY)/8.0
                                                     dirX:angles[angleByte].intXd
                                                     dirY:angles[angleByte].intYd
                                                   radius:0.0
                                                    delay:delay
                                            headingStable:(iFramesOfLevel >= FRAMES_TO_STABILIZE || [object calculatingHeading] == NO)
                                                 accuracy:&accuracy];
//                                                  delay:angleCount+iAngleOffs+2-iFrameOffs];
//                                                    delay:angleCount+iAngleOffs+4-iFrameOffs];
        if ( timeOfCollision > 0.0 ) {
          if ( targets[objCount].target == nil || accuracy < targets[objCount].accuracy ) {
            timeOfCollision += (double)iFrameOffs;
            target = [[APTarget alloc] initWithAngleByte:angleByte
                                               direction:iRotDirection
                                             frameOfShot:angleCount+iAngleOffs
                                                 waiting:iFrameOffs
                                                  object:object
                                              timeToShot:delay
                                          durationOfShot:timeOfCollision];
            targets[objCount].target = [target autorelease];
            targets[objCount].accuracy = accuracy;
          }
        }
      }
    }
    angleByte += (uint8_t)iRotDirection;
  }
  for (objCount = 0; objCount < numObjects; objCount++) {
    if ( targets[objCount].target != nil )
      [xListOfTargets addObject:targets[objCount].target];
  }

//  [pool release];
  return flgChecked;
}

@end
