//
//  APPlayer.h
//  APlayer
//
//  Created by Holger Sadewasser on 4/20/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APIOChannel.h"
#import "APTracker.h"
#import "APProphet.h"
#import "APKeySequence.h"


@interface APPlayer : NSObject <IOChannelDataCallback> {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------

  APIOChannel * mIOChannel;
  APTracker * mTracker;
  APProphet * mProphet;
  APKeySequence * mKeySequence;
  NSMutableArray * mTargets;
  unsigned int mMaxFrames;
  BOOL mFlgSaucerConsidered;
  BOOL mFlgWaiting;
  BOOL mFlgSynchronized;
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

- (id)initWithIOChannel:(APIOChannel *)iIOChannel maxFrames:(unsigned int)iMaxFrames;
- (void)dealloc;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------


@end
