//
//  APTargetList.h
//  APlayer
//
//  Created by Holger Sadewasser on 6/9/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APTarget.h"


@interface APTargetList : NSObject {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------
  
  NSMutableArray * mTargets;
  APTarget * mSaucer;
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)init;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)addObject:(APTarget *)iTarget;
-(void)addObjectsFromArray:(APTargetList *)iTargets;
-(void)removeAllObjects;
-(APTarget *)objectAtIndex:(unsigned)iIndex;
-(unsigned)count;
-(void)sortUsingSelector:(SEL)iComparator;
-(NSArray *)targets;
-(APTarget *)saucer;


@end
