/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas.modell;

import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import de.uhingen.kielkopf.andreas.UdpInterpreter;
import de.uhingen.kielkopf.andreas.exceptions.NotFallException;

/**
 * @author andreas
 * 
 */
public class Schiff extends FlugKoerper {
    /**
     * 
     */
    public static final int SCHIFFSIZE = 25;
    /**
     * 
     */
    private static final int _500     = 512;
    /**
     * 
     */
    private static final int _1000    = 1024;
    private static Schiff    schiff   = null;
    private double           richtung = 0;
    private int              kleinster_abstand;

    /**
     * @return das einzige Schiff, das es geben kann
     */
    public static synchronized Schiff getSchiff() {
        if (schiff == null) schiff = new Schiff();
        schiff.size = SCHIFFSIZE;
        return schiff;
    }
    /**
     * Änderungen an den Parametern x,y,z sollten irgenwie synchron erfolgen
     * 
     * @param erg
     *            Ergebniss der Untersuchung des letzten UDP-Paketes
     */
    public synchronized void aktualisierePos(final Drawable erg, final double winkel) {
        pos.x = erg.getX0();
        pos.y = erg.getY0();
        pos.z = erg.Time0();
        dpos.x = erg.getdX();
        dpos.y = erg.getdY();
        dpos.z = erg.dTime();
        richtung = winkel;
    }
    /**
     * @param ziel
     * @return
     * @throws NotFallException
     */
    public double schussWinkel(final Ziel ziel) throws NotFallException {
        if (ziel == null) return 0;
        try {
            UdpInterpreter.barier_winkel.reset();
            UdpInterpreter.barier_winkel.await(50, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (BrokenBarrierException e) {
            System.err.println("w");
        } catch (TimeoutException e) {}
        if (notFall(0)) throw new NotFallException("Kollision steht bevor");
        final int zielabstand = berechneAbstand2(ziel, 15);
        final int zukunft = (int) (zielabstand * 1.5);
        // System.out.println(zukunft);
        final double winkel = pos.getWinkel(ziel.getX0(zukunft), ziel.getY0(zukunft));
        Drawable.zielwinkel = winkel;
        Drawable.winkel = richtung;
        double erg = richtung - winkel;
        erg %= Math.PI;
        // System.out.println(((int) (erg * 180 / Math.PI)));
        return erg;
    }
    /**
     * @param drawable
     * @return Dringlichkeit eines Schusses
     */
    public int bewerteGefahr(final Drawable drawable) {
        kleinster_abstand = 100000;
        int treffpunkt = 0;
        suche_Minimum: for (int zukunft = 0; zukunft < 10000; zukunft += 1000) {
            final int abstand = berechneAbstand2(drawable, zukunft);
            if (abstand <= kleinster_abstand) {
                kleinster_abstand = abstand;
                treffpunkt = zukunft;
            } else {
                break suche_Minimum; // nicht weitersuchen wenn er sich entfernt
            }
        }
        if (kleinster_abstand < 0) kleinster_abstand = 0;
        int gefahr = (1000 - (kleinster_abstand * kleinster_abstand / 100) - (int) (treffpunkt / 50));
        if (gefahr > 1000) gefahr = 999;
        if (gefahr < 1) gefahr = 1;
        drawable.setGefahr(gefahr);
        // System.out.println(kleinster_abstand);
        return gefahr;
    }
    /**
     * @param drawable
     * @param zukunft
     * @return
     */
    private int berechneAbstand2(final FlugKoerper drawable, final int zukunft) {
        int dx = pos.x - drawable.getX0(zukunft);
        int dy = pos.y - drawable.getY0(zukunft);
        dx = Math.abs(((dx + _500) % _1000) - _500);
        dy = Math.abs(((dy + _500) % _1000) - _500);
        // int erg = (((dx * dx + dy * dy) / (dx + dy)) + dx + dy) / 2;
        int erg = (int) Math.sqrt(dx * dx + dy * dy);
        erg -= ((drawable.size + schiff.size) >> 1);
        return (erg < 0) ? 0 : erg;
    }
    public boolean notFall(int mindestabstand) {
        ArrayList<Drawable> list = UdpInterpreter.getCleanlist();
        for (Drawable drawable : list) {
            if (drawable.isUFO()) { // von UFOS abstand halten
                if (berechneAbstand2(drawable, 50) <= 50) return true;
            } else if (drawable.isAsteroid()) { // Asteroiden herrankommen lsaaen
                if (berechneAbstand2(drawable, 50) <= 0) return true;
            } else if (drawable.isSchuss()) {
                int jetzt = berechneAbstand2(drawable, 0);
                int nacher = berechneAbstand2(drawable, 200);
                drawable.naeherung *= 0.99d;
                drawable.naeherung += 0.01d * (jetzt - nacher-2);
               // System.out.println((int) drawable.naeherung);
                if (drawable.naeherung>0) { // eigene Schüsse ignorieren
                    if (berechneAbstand2(drawable, 100) <= 10) return true;
                }
            }
        }
        return false;
    }
}
