package de.fhr.asteroids;

import java.awt.Color;

/**
 * The explosion of a game object.
 * @author Florian Lutz
 * @version 1.1
 */
final class Explosion extends GameObject {

  /**
   * X-values of the explosion particle points.
   */
  private final double[] epx = new double[20];

  /**
   * Y-values of the explosion particle points.
   */
  private final double[] epy = new double[20];

  /**
   * The scaling factor.
   */
  private int gsf;

  /**
   * The type of the explosion.
   */
  private int type;

  /**
   * Creates a new expolsion with the specified data.
   * @param px the x-value of the explosion
   * @param py the y-value of the explosion
   * @param type the type
   * @param gsf the scaling factor
   */
  Explosion(final int px, final int py, final int type, final int gsf) {
    super(px, py);
    this.type = type;
    this.gsf = gsf;
    for (int i = 0; i < 20; i++) {
      epx[i] = Math.random() * 4 - 2;
      epy[i] = Math.random() * 4 - 2;
    }
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.Drawable#draw(de.fhr.asteroids.FlipGraphics)
   */
  @Override
  public void draw(final FlipGraphics g) {
    final int r = radius();
    g.setColor(Color.WHITE);
    for (int i = 0; i < 20; i++) {
      final int x = px + (int)(epx[i] * r);
      final int y = py + (int)(epy[i] * r);
      g.drawLine(x, y, x, y);
    }
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.ScreenObject#radius()
   */
  @Override
  int radius() {
    return (gsf < 10 ? gsf + 6 : gsf - 10) * 4 + type;
  }

  /**
   * Updates type and scaling factor of this explosion.
   * @param npx the x-value of the explosion position
   * @param npy the x-value of the explosion position
   * @param ntype the new type of the explosion
   * @param ngsf the new scaling factor of this explosion
   */
  void update(final int npx, final int npy, final int ntype, final int ngsf) {
    update(npx, npy);
    type = ntype;
    gsf = ngsf;
  }
}
