package de.fhr.asteroids;

/**
 * A frame that is received from the asteroids host. The received raw byte data
 * is decoded to words with correct endianess.
 * @author Florian Lutz
 * @version 1.1
 */
final class Frame {

  /**
   * The decoded vector data.
   */
  int[] data;

  /**
   * The number of the frame.
   */
  int number;

  /**
   * The ping value that has been sent back by the remote host.
   */
  int ping;

  /**
   * Creates a new frame without data.
   */
  Frame() {
    super();
  }

  /**
   * Sets the data this frame should decode an contain.
   * @param rawdata the raw byte data
   */
  void data(final byte[] rawdata) {
    if (rawdata.length < 1026) {
      throw new RuntimeException("not enough data for frame");
    }

    data = new int[512];
    for (int i = 0; i < 512; i++) {
      // combinte two bytes to a 16-bit word
      data[i] = ((rawdata[2 * i + 1] & 0xff) << 8) + (rawdata[2 * i] & 0xff);
    }

    if (data[0] != 0xe001 && data[0] != 0xe201) {
      throw new RuntimeException("invalid start of vector data");
    }

    number = rawdata[1024] & 0xFF;
    ping = rawdata[1025] & 0xFF;
  }
}
