package de.fhr.asteroids;

/**
 * Static class for tables with specific values.
 * @author Florian Lutz
 * @version 1.1
 */
final class Tables {

  /**
   * Private default constructor.
   */
  private Tables() {
    // no initialisation needed
  }

  /**
   * Temporary array for calulations.
   */
  private static final int[] TMPAR;

  /**
   * The internal angle in degrees for each angelbyte value.
   */
  static final double[] ANGLE;

  /**
   * The x-extent of the asteroids screen.
   */
  static final int EXTENT_X = 1024;

  /**
   * The y-extent of the asteroids screen.
   */
  static final int EXTENT_Y = 768;

  /**
   * The vector ram addresses of characters.
   */
  static final int[] JSRLADDR;

  /**
   * The characters corresponding to the chracter addresses.
   */
  static final char[] JSRLCHAR;

  /**
   * The mean speed of shots.
   */
  static final double SHOTSPEED = 8.0;

  /**
   * The possible x-value of the ship screen vector for each angelbyte value.
   */
  static final int[] SVECX;

  /**
   * The possible y-value of the ship screen vector for each angelbyte value.
   */
  static final int[] SVECY;

  static {
    TMPAR = new int[10];
    ANGLE =
        new double[] { 0.0, 3.6214871724996494, 8.28231665463415,
            12.724355685422365, 16.394149912760803, 21.52577819602089,
            25.11985152755379, 29.183742741019916, 33.393413344263344,
            37.81146432829826, 41.663689335263285, 46.273030020056716,
            50.67044358091614, 55.30484646876603, 59.34933204294713,
            63.43494882292202, 67.5205656028969, 71.56505117707799,
            76.30606256395879, 79.77723551173115, 84.57677771902713,
            89.27473605497192, 92.89963685671033, 97.25754681994427,
            102.00292546002633, 105.4499728902289, 110.13630342824814,
            114.14554196042165, 118.17859010995917, 122.76969486770659,
            126.78781104696483, 131.18592516570965, 135.0, 139.35940925795006,
            143.2121889530352, 147.80426606528675, 151.82140989004085,
            156.5158864186266, 160.55542596222875, 164.62894075348763,
            169.18217367972338, 172.74028089345444, 177.47865955005256,
            181.78991060824606, 185.4575497542541, 190.1112678535266,
            194.47029410006587, 198.10227303954107, 203.19824947016343,
            207.02873114352568, 210.9022150006733, 215.30070021943078,
            219.66898600710294, 223.72696997994328, 227.2912087790262,
            232.188506251016, 235.90460965784428, 240.25511870305775,
            245.1991017461243, 248.81114624944797, 252.4958574351537,
            257.2756443145776, 260.9525565115186, 265.69465918715804, 270.0,
            273.5763343749974, 277.97746664098224, 282.7243556854224,
            286.4866524274802, 291.188853750552, 294.80089825387597,
            298.8257537898793, 303.48595966691033, 307.81149374898393,
            311.9059156560485, 316.2730300200567, 319.82686138131123,
            324.6992997805692, 328.7251929235525, 332.7831878280328,
            336.5079416543816, 341.565051177078, 345.3444743747045,
            350.10232244457666, 354.5751561867406, 358.187421318324,
            2.897795785679188, 7.214266917580418, 10.954062643398332,
            15.701440725412395, 19.120464480849968, 23.468285124797898,
            28.17859010995917, 32.76969486770661, 36.78736619460015,
            40.64059074204994, 45.00000000000001, 49.36003125006832,
            53.21218895303518, 57.2303051322934, 61.82140989004083,
            66.84908013049431, 70.8647738856426, 74.22516479845042,
            79.04593735660166, 82.74245318005575, 87.10220421432076,
            91.81255392341097, 95.42322228097288, 100.22276448826885,
            104.73935622334835, 108.4349487666414, 113.15091986950569,
            117.52422707928176, 121.27483895904373, 125.5661222442731,
            130.14906173144172, 133.72696997994328, 138.33631066473674,
            142.18853567170174, 146.60658665573666, 151.1884937763804,
            154.8904348724049, 158.80619133220932, 163.6058605178166,
            167.27564431457765, 172.02319798084534, 176.42366562500263, 180.0,
            184.30534081284193, 189.0475658802272, 192.72435568542235,
            197.09766877123283, 201.19380866779068, 205.1095651275951,
            209.7448812969422, 214.27727967319075, 217.81146432829826,
            222.69681429942872, 226.27303002005672, 230.3081153222336,
            234.69993375509495, 239.0919017356869, 242.97126885647432,
            246.8085696560159, 251.79683051249333, 255.5297058999341,
            259.90418185071786, 264.54252486168826, 268.21008939175397,
            272.5213404499476, 277.2596203136653, 280.8176810310141,
            285.79123709397874, 289.13519105422085, 293.4840793987354,
            298.17859010995915, 302.19573393471325, 306.5920832973065,
            310.36516511941085, 315.0, 318.81407483429035, 323.21263380539983,
            327.2303051322934, 331.82140989004085, 335.85445803957833,
            339.86369657175186, 344.2985592745876, 348.3189999586723,
            352.7857330824196, 357.1022042143208, 0.7252639450278633,
            5.423222280972888, 9.897677555423332, 13.5995292578431,
            18.434948822922, 22.479434397103123, 26.565051177078008,
            30.65066795705287, 34.69515353123396, 39.34051697591572,
            43.7269699799433, 48.094059310586026, 51.90355537939005,
            56.51382122521671, 60.3464011412778, 64.72493105343172,
            68.59497079927363, 73.5131261173221, 77.27564431457763,
            81.71768334536583, 86.37851282750033, 90.0, 94.70283818406297,
            98.99125332141455, 102.72435568542237, 107.50511617902191,
            111.52577819483707, 115.27506894656828, 120.28202047908434,
            124.27727967319075, 127.81149374898385, 132.20170438486295,
            136.27303002005672, 140.6594830240843, 145.30484646876604,
            149.71758623271108, 153.9177499124552, 157.79681666733978,
            161.89772696045893, 166.57418895206132, 169.8887321464734,
            174.5424502457459, 178.92664172731105, 182.52130369532557,
            187.21641403887594, 191.8695000257843, 195.35468190291905,
            200.13630342824814, 204.14554196042164, 208.17859010995915,
            212.19573393471325, 216.78736619460014, 221.18592516570965, 225.0,
            228.81407483429035, 233.4079167026935, 237.80426606528675,
            241.82140989004083, 245.85445803957833, 249.86369657175186,
            254.20876290602126, 258.1457907695991, 262.7403796863347,
            267.4786595500524, 271.0733582726888, 275.45747513831174,
            280.09581814928214, 283.4258470124139, 288.20316948750667,
            292.1972809093799, 296.08223381667756, 300.1017130653084,
            304.695153531234, 309.1119081507725, 313.72697100346437,
            317.54611490700495, 322.18853567170174, 325.7227203268092,
            329.89011482998137, 334.8801484724462, 338.4742218039791,
            342.9032515830129, 347.2756443145776, 351.00874667858545,
            355.29716181593693 };
    SVECX =
        new int[] { 1536, 1536, 1528, 1504, 1472, 1472, 1416, 1360, 1280, 1280,
            1192, 1088, 976, 976, 856, 720, 584, 584, 440, 296, 152, 152, -152,
            -296, -296, -440, -584, -720, -720, -856, -976, -1088, -1088,
            -1192, -1280, -1360, -1360, -1416, -1472, -1504, -1504, -1528,
            -1536, -1536, -1528, -1528, -1504, -1472, -1416, -1416, -1360,
            -1280, -1192, -1192, -1088, -976, -856, -856, -720, -584, -440,
            -440, -296, -152, 0, 152, 296, 440, 440, 584, 720, 856, 856, 976,
            1088, 1192, 1192, 1280, 1360, 1416, 1416, 1472, 1504, 1528, 1528,
            1536, 1536, 1528, 1504, 1504, 1472, 1416, 1360, 1360, 1280, 1192,
            1088, 1088, 976, 856, 720, 720, 584, 440, 296, 296, 152, -152,
            -152, -296, -440, -584, -584, -720, -856, -976, -976, -1088, -1192,
            -1280, -1280, -1360, -1416, -1472, -1472, -1504, -1528, -1536,
            -1536, -1536, -1528, -1504, -1472, -1472, -1416, -1360, -1280,
            -1280, -1192, -1088, -976, -976, -856, -720, -584, -584, -440,
            -296, -152, -152, 152, 296, 296, 440, 584, 720, 720, 856, 976,
            1088, 1088, 1192, 1280, 1360, 1360, 1416, 1472, 1504, 1504, 1528,
            1536, 1536, 1528, 1528, 1504, 1472, 1416, 1416, 1360, 1280, 1192,
            1192, 1088, 976, 856, 856, 720, 584, 440, 440, 296, 152, 0, -152,
            -296, -440, -440, -584, -720, -856, -856, -976, -1088, -1192,
            -1192, -1280, -1360, -1416, -1416, -1472, -1504, -1528, -1528,
            -1536, -1536, -1528, -1504, -1504, -1472, -1416, -1360, -1360,
            -1280, -1192, -1088, -1088, -976, -856, -720, -720, -584, -440,
            -296, -296, -152, 152, 152, 296, 440, 584, 584, 720, 856, 976, 976,
            1088, 1192, 1280, 1280, 1360, 1416, 1472, 1472, 1504, 1528, 1536 };
    SVECY =
        new int[] { 0, 0, 152, 296, 440, 440, 584, 720, 856, 856, 976, 1088,
            1192, 1192, 1280, 1360, 1416, 1416, 1472, 1504, 1528, 1528, 1528,
            1504, 1504, 1472, 1416, 1360, 1360, 1280, 1192, 1088, 1088, 976,
            856, 720, 720, 584, 440, 296, 296, 152, 0, 0, -152, -152, -296,
            -440, -584, -584, -720, -856, -976, -976, -1088, -1192, -1280,
            -1280, -1360, -1416, -1472, -1472, -1504, -1528, -1536, -1528,
            -1504, -1472, -1472, -1416, -1360, -1280, -1280, -1192, -1088,
            -976, -976, -856, -720, -584, -584, -440, -296, -152, -152, 0, 0,
            152, 296, 296, 440, 584, 720, 720, 856, 976, 1088, 1088, 1192,
            1280, 1360, 1360, 1416, 1472, 1504, 1504, 1528, 1528, 1528, 1504,
            1472, 1416, 1416, 1360, 1280, 1192, 1192, 1088, 976, 856, 856, 720,
            584, 440, 440, 296, 152, 0, 0, 0, -152, -296, -440, -440, -584,
            -720, -856, -856, -976, -1088, -1192, -1192, -1280, -1360, -1416,
            -1416, -1472, -1504, -1528, -1528, -1528, -1504, -1504, -1472,
            -1416, -1360, -1360, -1280, -1192, -1088, -1088, -976, -856, -720,
            -720, -584, -440, -296, -296, -152, 0, 0, 152, 152, 296, 440, 584,
            584, 720, 856, 976, 976, 1088, 1192, 1280, 1280, 1360, 1416, 1472,
            1472, 1504, 1528, 1536, 1528, 1504, 1472, 1472, 1416, 1360, 1280,
            1280, 1192, 1088, 976, 976, 856, 720, 584, 584, 440, 296, 152, 152,
            0, 0, -152, -296, -296, -440, -584, -720, -720, -856, -976, -1088,
            -1088, -1192, -1280, -1360, -1360, -1416, -1472, -1504, -1504,
            -1528, -1528, -1528, -1504, -1472, -1416, -1416, -1360, -1280,
            -1192, -1192, -1088, -976, -856, -856, -720, -584, -440, -440,
            -296, -152, 0 };
    JSRLADDR =
        new int[] { 0xB2E, 0xB32, 0xB3A, 0xB41, 0xB48, 0xB4F, 0xB56, 0xB5B,
            0xB63, 0xADD, 0xA78, 0xA80, 0xA8D, 0xA93, 0xA9B, 0xAA3, 0xAAA,
            0xAB3, 0xABA, 0xAC1, 0xAC7, 0xACD, 0xAD2, 0xAD8, 0xAE3, 0xAEA,
            0xAF3, 0xAFB, 0xB02, 0xB08, 0xB0E, 0xB13, 0xB1A, 0xB1F, 0xB26,
            0xB2C };
    JSRLCHAR =
        new char[] { '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'A',
            'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
            'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ' };
  }

  /**
   * Returns an array of the valid internal angles for the specified display
   * vector.
   * @param sdx the x-value of the display vector
   * @param sdy the y-value of the display vector
   * @return the valie internal angles
   */
  static int[] goodab(final int sdx, final int sdy) {
    int n = 0;
    for (int i = 0; i < 256; i++) {
      if (Tables.SVECX[i] == sdx && Tables.SVECY[i] == sdy) {
        TMPAR[n++] = i;
      }
    }
    final int[] goodab = new int[n];
    System.arraycopy(TMPAR, 0, goodab, 0, n);
    return goodab;
  }
}
