/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetList
implements IDrawable {
    private List<IPositionable> targets = new Vector<IPositionable>();
    private static final int CIRCLE_SIZE = 50;

    public List<IPositionable> getTargets() {
        return this.targets;
    }

    public void addTarget(IPositionable target) {
        this.targets.add(target);
    }

    public synchronized IPositionable getFirstTarget() {
        if (this.targets.size() > 0) {
            return this.targets.get(0);
        }
        return null;
    }

    @Override
    public void draw(Graphics2D g, Graphics2D textG) {
        IPositionable target = this.getFirstTarget();
        if (target != null) {
            g.setColor(Color.RED);
            g.drawOval(target.getPosition().getCurVector().x - 25, target.getPosition().getCurVector().y - 25, 50, 50);
        }
    }
}

