/*
 * Created on Apr 19, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Vector;

public class VectorCalculations {
    private final static Log log = LogFactory.getLog(VectorCalculations.class);

    public final static double getDistance(Vector v1, Vector v2) {
        Vector diff = getDifferenceNormalized(v1, v2);
        return getNorm(diff);
    }

    public final static double getDistance(IPositionable v1, IPositionable v2) {
        return getDistance(v1.getPosition().getCurVector(), v2.getPosition().getCurVector());
    }

    public final static double getNorm(Vector v) {
        return Math.sqrt( (v.x * v.x) + (v.y * v.y) );
    }

    public final static double getScalarProduct(Vector v1, Vector v2) {
        return (v1.x * v2.x) + (v1.y * v2.y);
    }

    /**
     * Gets the angle between v1 and v2.
     *
     * This always returns the smaller angle.
     *
     * @param source
     * @param target
     * @return
     */
    public final static double getAngleBetween(Vector v1, Vector v2) {
        double scalarProd = getScalarProduct(v1, v2);
        double normSource = getNorm(v1);
        double normTarget = getNorm(v2);

        double angle = Math.acos(scalarProd / (normSource * normTarget));

        //log.debug("scalarProd: " + scalarProd + " norm1: " + normSource + " norm2: " + normTarget + " angle: " + angle);

        // This is bullshit ... because it always returns something between 0 and 180 degrees
        /*
        if (angle > (Math.PI / 2)) {
            angle = Math.PI - angle;
        }
        */

        return angle;
    }

    /**
     * Gets the polar angle of the vector from source to target.
     *
     * @param source
     * @param target
     * @return
     */
    public final static double getAngle(IPositionable source, IPositionable target) {
        return getAngle(source.getPosition().getCurVector(), target.getPosition().getCurVector());
    }

    /**
     * Gets the polar angle of the vector from source to target.
     *
     * @param source
     * @param target
     * @return
     */
    public final static double getAngle(Vector source, Vector target) {
        Vector diff = getDifference(source, target);

        return Math.atan2(diff.y, diff.x);
    }

    public final static Vector getDifference(Vector from, Vector to) {
        return new Vector(to.x - from.x, to.y - from.y);
    }

    public final static Vector getDifferenceNormalized(Vector from, Vector to) {
        int dx = to.x - from.x;
        int dy = to.y - from.y;

        // dx normalisieren auf -512 ... 511
        while (dx < -512) dx += 1024;
        while (dx > 511) dx -= 1024;

        // dy normalisieren auf -384 ... 383
        while (dy < -384) dy += 768;
        while (dy > 383) dy -= 768;

        return new Vector(dx, dy);
    }

}
