\name{makeMafDbPackageKG}
\alias{makeMafDbPackageKG}
\alias{MafDbKGdefaultURL}
\alias{MafDbKGdefaultPkgName}

\title{
Make a MafDb annotation data package from the 1000 Genomes Project
}
\description{
 This function creates an annotation data package for a MafDb object. Its primary purpose is to
 ease the task of fetching and packaging newer minimum allele frequency data.
}
\usage{
makeMafDbPackageKG(destDir=path.expand("~"), MafDbURL=MafDbKGdefaultURL, MafDbPkgName=MafDbKGdefaultPkgName,
                   genome="hg19", version=NULL, author=NULL, maintainer=NULL, license=NULL, yieldSize=1000000)

}
\arguments{
  \item{destDir}{Destination directory for the newly created package.}
  \item{MafDbURL}{URL to the source VCF file(s). By default, it points to the URL holding the data currently stored in the package that defines this function.}
  \item{MafDbPkgName}{Name of the newly created package. This will define as well the name of the exported MafDb object.}
  \item{genome}{Version of the human genome, following UCSC nomenclature. Necessary for the internal call to the \code{readVcf()} function from the \code{VariantAnnotation} package.}
  \item{version}{Version to put on the new package. By default, the version corresponds to the version of the package that defines this function, bumping the second version number.}
  \item{author}{Author to put on the new package. By default, the author corresponds to the author of the package that defines this function.}
  \item{maintainer}{Maintainer to put on the new package. By default, the maintainer corresponds to the maintainer of the package that defines this function.}
  \item{license}{License to put on the new package. By default, the license corresponds to the license of the package that defines this function.}
  \item{yieldSize}{In the case source tabix VCF files, they are not read at once, but scanned in batches whose size is determined by this argument. By default is set to one million variants but it may be reduced to lower main memory requirements.}
}
\value{
Path to the folder containing the created data package.
}
\author{
 R. Castelo
}
\seealso{
  \code{\link[VariantFiltering]{fetchKnownVariantsByID}}
  \code{\link{MafDb.ALL.wgs.phase1.release.v3.20101123}}
}
\examples{
MafDbKGdefaultURL ## default URL from where makeMafDbPackageKG() fetches the MAF data

MafDbKGdefaultPkgName ## default name for the package that makeMafDbPackageKG() creates

\dontrun{
## the previous two default values can be overridden when calling makeMafDbPackageKG()
makeMafDbPackageKG()
}
}
\keyword{utilities}
