### R code from vignette source 'affydata.Rnw'

###################################################
### code chunk number 1: affydata.Rnw:47-49
###################################################
library(affydata)
data(Dilution)


###################################################
### code chunk number 2: affydata.Rnw:61-62
###################################################
Dilution


###################################################
### code chunk number 3: affydata.Rnw:69-71
###################################################
phenoData(Dilution)
pData(Dilution)


###################################################
### code chunk number 4: affydata.Rnw:83-84
###################################################
pData(Dilution) ##notice the scanner covariate


###################################################
### code chunk number 5: affydata.Rnw:94-96
###################################################
par(mfrow=c(1,1))
boxplot(Dilution,col=c(2,2,3,3))


###################################################
### code chunk number 6: affydata.Rnw:117-118
###################################################
options(warn=-1)


###################################################
### code chunk number 7: affydata.Rnw:122-125
###################################################
gn <- sample(geneNames(Dilution),100) ##pick only a few genes
pms <- pm(Dilution[,3:4], gn)
mva.pairs(pms)


###################################################
### code chunk number 8: affydata.Rnw:134-136
###################################################
normalized.Dilution <- Biobase::combine(normalize(Dilution[, 1:2]),
                             normalize(Dilution[, 3:4]))


###################################################
### code chunk number 9: affydata.Rnw:145-146
###################################################
normalize.methods(Dilution)


###################################################
### code chunk number 10: affydata.Rnw:158-159
###################################################
boxplot(normalized.Dilution, col=c(2,2,3,3), main="Normalized Arrays")


###################################################
### code chunk number 11: affydata.Rnw:169-171
###################################################
pms <- pm(normalized.Dilution[, 3:4],gn)
mva.pairs(pms)


