### R code from vignette source 'ALDEx2_vignette.Rnw'

###################################################
### code chunk number 1: ALDEx2_vignette.Rnw:49-53
###################################################
library(ALDEx2)
data(selex)
#subset for efficiency
selex <- selex[1201:1600,]


###################################################
### code chunk number 2: ALDEx2_vignette.Rnw:59-60
###################################################
conds <- c(rep("NS", 7), rep("S", 7))


###################################################
### code chunk number 3: ALDEx2_vignette.Rnw:65-70
###################################################
x <- aldex(selex, conds, mc.samples=16, test="t", effect=TRUE,
     include.sample.summary=FALSE, denom="iqlr", verbose=FALSE)

aldex.plot(x, type="MA", test="welch")
aldex.plot(x, type="MW", test="welch")


###################################################
### code chunk number 4: ALDEx2_vignette.Rnw:79-80
###################################################
x <- aldex.clr(selex, conds, mc.samples=16, denom="iqlr", verbose=TRUE)


###################################################
### code chunk number 5: ALDEx2_vignette.Rnw:87-88
###################################################
x.tt <- aldex.ttest(x, conds, paired.test=TRUE)


###################################################
### code chunk number 6: ALDEx2_vignette.Rnw:92-93 (eval = FALSE)
###################################################
## x.glm <- aldex.glm(x, conds)


###################################################
### code chunk number 7: ALDEx2_vignette.Rnw:98-99
###################################################
x.effect <- aldex.effect(x, conds, include.sample.summary=FALSE, verbose=TRUE)


###################################################
### code chunk number 8: ALDEx2_vignette.Rnw:103-104
###################################################
x.all <- data.frame(x.tt,x.effect)


###################################################
### code chunk number 9: ALDEx2_vignette.Rnw:120-124
###################################################

par(mfrow=c(1,2))
aldex.plot(x.all, type="MA", test="welch")
aldex.plot(x.all, type="MW", test="welch")


###################################################
### code chunk number 10: ALDEx2_vignette.Rnw:181-197
###################################################

# identify which values are significant in both the t-test and glm tests
found.by.all <- which(x.all$we.eBH < 0.05 & x.all$wi.eBH < 0.05)

# identify which values are significant in fewer than all tests
found.by.one <- which(x.all$we.eBH < 0.05 | x.all$wi.eBH < 0.05)

# plot the within and between variation of the data
plot(x.all$diff.win, x.all$diff.btw, pch=19, cex=0.3, col=rgb(0,0,0,0.3),
 xlab="Difference within", ylab="Difference between")
points(x.all$diff.win[found.by.one], x.all$diff.btw[found.by.one], pch=19,
 cex=0.5, col=rgb(0,0,1,0.5))
points(x.all$diff.win[found.by.all], x.all$diff.btw[found.by.all], pch=19,
 cex=0.5, col=rgb(1,0,0,1))
abline(0,1,lty=2)
abline(0,-1,lty=2)


###################################################
### code chunk number 11: ALDEx2_vignette.Rnw:225-240 (eval = FALSE)
###################################################
## # small synthetic dataset for illustration
## # denominator features in x@denominator
## 
## data(synth2)
## blocks <- c(rep("N", 10),rep("S", 10))
## x <- aldex.clr(synth2, blocks, denom="all")
## x.e <- aldex.effect(x, blocks)
## plot(x.e$diff.win, x.e$diff.btw, pch=19, col=rgb(0,0,0,0.1), cex=0.5, xlab="dispersion", ylab="difference", main="all")
## points(x.e$diff.win[x@denom], x.e$diff.btw[x@denom], pch=19, col=rgb(0.8,0.5,0,0.7), cex=0.5)
## points(x.e$diff.win[47:86], x.e$diff.btw[47:86], col=rgb(0.8,0,0,0.7), cex=0.5)
## points(x.e$diff.win[980:1000], x.e$diff.btw[980:1000], col=rgb(0.8,0,0,0.7), cex=0.5)
## abline(0,1)
## abline(0,-1)
## abline(h=0, col="gray", lty=2)
## 


###################################################
### code chunk number 12: ALDEx2_vignette.Rnw:246-283
###################################################

# plot it
par(mfrow=c(1,3))
data(synth2)
blocks <- c(rep("N", 10),rep("S", 10))
x <- aldex.clr(synth2, blocks, denom="all")
x.e <- aldex.effect(x, blocks)

plot(x.e$diff.win, x.e$diff.btw, pch=19, col=rgb(0,0,0,0.1), cex=0.5, xlab="dispersion", ylab="difference", main="all")
points(x.e$diff.win[x@denom], x.e$diff.btw[x@denom], pch=19, col=rgb(0.8,0.5,0,0.7), cex=0.5)
points(x.e$diff.win[47:86], x.e$diff.btw[47:86], col=rgb(0.8,0,0,0.7), cex=0.5)
points(x.e$diff.win[980:1000], x.e$diff.btw[980:1000], col=rgb(0.8,0,0,0.7), cex=0.5)
abline(0,1)
abline(0,-1)
abline(h=0, col="gray", lty=2)

x <- aldex.clr(synth2, blocks, denom="iqlr")
x.e <- aldex.effect(x, blocks)
plot(x.e$diff.win, x.e$diff.btw, pch=19, col=rgb(0,0,0,0.1), cex=0.5, xlab="dispersion", ylab="difference", main="iqlr")
points(x.e$diff.win[x@denom], x.e$diff.btw[x@denom], pch=19, col=rgb(0.8,0.5,0,0.7), cex=0.5)
points(x.e$diff.win[47:86], x.e$diff.btw[47:86], col=rgb(0.8,0,0,0.7), cex=0.5)
points(x.e$diff.win[980:1000], x.e$diff.btw[980:1000], col=rgb(0.8,0,0,0.7), cex=0.5)
abline(0,1)
abline(0,-1)
abline(h=0, col="gray", lty=2)

x <- aldex.clr(synth2, blocks, denom="lvha")
x.e <- aldex.effect(x, blocks)
plot(x.e$diff.win, x.e$diff.btw, pch=19, col=rgb(0,0,0,0.1), cex=0.5, xlab="dispersion", ylab="difference", main="lvha")
points(x.e$diff.win[x@denom], x.e$diff.btw[x@denom], pch=19, col=rgb(0.8,0.5,0,0.7), cex=0.5)
points(x.e$diff.win[47:86], x.e$diff.btw[47:86], col=rgb(0.8,0,0,0.7), cex=0.5)
points(x.e$diff.win[980:1000], x.e$diff.btw[980:1000], col=rgb(0.8,0,0,0.7), cex=0.5)
abline(0,1)
abline(0,-1)
abline(h=0, col="gray", lty=2)




