### R code from vignette source 'EBSEA.Rnw'

###################################################
### code chunk number 1: load
###################################################
library(EBSEA)
data("origCounts")
head(origCounts)


###################################################
### code chunk number 2: EBSEA
###################################################
group <- c('Group1', 'Group1', 'Group1', 'Group2', 'Group2', 'Group2', 'Group2')
result <- EBSEA(origCounts, group, plot = TRUE)


###################################################
### code chunk number 3: table
###################################################
result$ExonTable <- result$ExonTable[order(result$ExonTable$GeneExon), ]


###################################################
### code chunk number 4: exontable
###################################################
head(result$ExonTable)


###################################################
### code chunk number 5: genetable
###################################################
head(result$GeneTable)


###################################################
### code chunk number 6: gene
###################################################
visualizeGenes('FBgn0000064', result)


