/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public class RunningProcessChecker {
    private static boolean runningProcessesChecked = false;

    public static boolean checkRunningProcesses(Context context, String string, boolean bl) throws UserCanceledException {
        ResourceBundle resourceBundle;
        String string2;
        int n;
        InstallationProperties installationProperties = ((ContextImpl)context).getInstallationProperties();
        if (!InstallerUtil.isWindows() || runningProcessesChecked) {
            return true;
        }
        do {
            List list;
            if ((list = RunningProcessChecker.getRunningProcesses(installationProperties, context.getInstallationDirectory(), bl)).size() == 0) {
                runningProcessesChecked = true;
                return true;
            }
            if (!context.isUnattended()) continue;
            System.err.println("The application is running. Please close all instances and run this installer again.");
            return false;
        } while ((n = GUIHelper.showOptionDialog(null, string2 = MessageFormat.format((resourceBundle = Messages.getMessages()).getString(string), InstallerConfig.getCurrentInstance().getApplicationName()), new String[]{resourceBundle.getString("ButtonOK"), resourceBundle.getString("ButtonCancel")}, 2)) != 1);
        return false;
    }

    private static List getRunningProcesses(InstallationProperties installationProperties, File file, boolean bl) {
        ArrayList<File> arrayList;
        block9: {
            arrayList = new ArrayList<File>();
            try {
                String[] stringArray;
                Set set = installationProperties.getCanonicalFilePropertySet("launcher");
                if (bl) {
                    set.add(new File(file, "uninstall.exe").getCanonicalFile());
                }
                RunningProcessThread runningProcessThread = new RunningProcessThread();
                runningProcessThread.start();
                try {
                    runningProcessThread.join(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (runningProcessThread.isAlive()) {
                    runningProcessThread.stop();
                }
                if ((stringArray = runningProcessThread.getModules()) == null) break block9;
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2;
                    try {
                        file2 = new File(stringArray[i]).getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    if (!set.contains(file2)) continue;
                    arrayList.add(file2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static class RunningProcessThread
    extends Thread {
        private String[] modules = null;

        public RunningProcessThread() {
            super("running-process-thread");
            this.setDaemon(true);
            this.setPriority(3);
        }

        public String[] getModules() {
            return this.modules;
        }

        public void run() {
            this.modules = Misc.getRunningUserProcesses();
        }
    }
}

