/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util;

import com.sosnoski.util.ArrayRangeIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SparseArrayIterator
implements Iterator {
    protected Object[] m_array;
    protected int m_offset;

    private SparseArrayIterator(Object[] objectArray) {
        this.m_array = objectArray;
        this.m_offset = -1;
        this.advance();
    }

    protected boolean advance() {
        while (++this.m_offset < this.m_array.length) {
            if (this.m_array[this.m_offset] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.m_offset < this.m_array.length;
    }

    public Object next() {
        if (this.m_offset < this.m_array.length) {
            Object object = this.m_array[this.m_offset];
            this.advance();
            return object;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static Iterator buildIterator(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return ArrayRangeIterator.EMPTY_ITERATOR;
        }
        return new SparseArrayIterator(objectArray);
    }
}

