/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.LayerComposition;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public abstract class Layer {
    private static ColorModel maskColorModel;
    protected LayerComposition parent;
    protected Composite composite;
    protected Shape clippingArea;
    protected BufferedImage layerMask;
    protected Rectangle layerMaskRect;
    protected RenderingHints hints;
    protected AffineTransform transform;
    protected LayerFilter filter;

    public LayerFilter getFilter() {
        return this.filter;
    }

    public void setImageFilter(BufferedImageOp bufferedImageOp) {
        this.setImageFilter(bufferedImageOp, new Dimension(0, 0));
    }

    public void setRasterFilter(RasterOp rasterOp) {
        this.setRasterFilter(rasterOp, new Dimension(0, 0));
    }

    public void setImageFilter(BufferedImageOp bufferedImageOp, Dimension dimension) {
        this.filter = new LayerFilter(bufferedImageOp, (Dimension)dimension.clone());
    }

    public void setRasterFilter(RasterOp rasterOp, Dimension dimension) {
        this.filter = new LayerFilter(rasterOp, (Dimension)dimension.clone());
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform != null ? (AffineTransform)affineTransform.clone() : null;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setClip(Shape shape) {
        this.clippingArea = shape;
    }

    public Shape getClip() {
        return this.clippingArea;
    }

    public void setLayerMask(Shape shape) {
        this.setLayerMask(shape, false);
    }

    public void setLayerMask(Shape shape, boolean bl) {
        BufferedImage bufferedImage = null;
        Rectangle rectangle = null;
        if (!bl) {
            rectangle = shape.getBounds();
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.white);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.fill(shape);
            graphics2D.dispose();
        } else {
            rectangle = this.parent.getBounds();
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.white);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics2D.setPaint(Color.black);
            graphics2D.fill(shape);
            graphics2D.dispose();
        }
        this.setLayerMask(bufferedImage, rectangle);
    }

    public void setLayerMask(BufferedImage bufferedImage) {
        this.setLayerMask(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public void setLayerMask(BufferedImage bufferedImage, Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (bufferedImage.getColorModel() != maskColorModel) {
            Object object;
            if (bufferedImage.getType() != 10) {
                object = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                bufferedImage = colorConvertOp.filter(bufferedImage, (BufferedImage)object);
            }
            object = bufferedImage.getRaster();
            bufferedImage = new BufferedImage(maskColorModel, (WritableRaster)object, false, null);
        }
        this.layerMask = bufferedImage;
        this.layerMaskRect = rectangle;
    }

    public BufferedImage getLayerMask() {
        return this.layerMask;
    }

    public Rectangle getLayerMaskRect() {
        return this.layerMaskRect;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.hints = renderingHints;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.hints == null) {
            this.hints = new RenderingHints(key, object);
        } else {
            this.hints.put(key, object);
        }
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public abstract void paint(Graphics2D var1);

    public abstract Rectangle2D getBounds();

    protected Layer(LayerComposition layerComposition) {
        if (layerComposition == null) {
            throw new IllegalArgumentException("null parent composition");
        }
        this.parent = layerComposition;
    }

    static {
        byte[] byArray = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)i;
        }
        maskColorModel = new IndexColorModel(8, 256, byArray, byArray, byArray, byArray);
    }

    public static class LayerFilter {
        private BufferedImageOp bFilter;
        private RasterOp rFilter;
        private Dimension filterMargins;

        public LayerFilter(BufferedImageOp bufferedImageOp) {
            this.bFilter = bufferedImageOp;
            this.filterMargins = new Dimension(0, 0);
        }

        public LayerFilter(RasterOp rasterOp) {
            this.rFilter = rasterOp;
            this.filterMargins = new Dimension(0, 0);
        }

        public LayerFilter(BufferedImageOp bufferedImageOp, Dimension dimension) {
            this.bFilter = bufferedImageOp;
            this.filterMargins = (Dimension)dimension.clone();
        }

        public LayerFilter(RasterOp rasterOp, Dimension dimension) {
            this.rFilter = rasterOp;
            this.filterMargins = (Dimension)dimension.clone();
        }

        public boolean isRasterFilter() {
            return this.rFilter != null;
        }

        public Dimension getFilterMargins() {
            return (Dimension)this.filterMargins.clone();
        }

        public BufferedImageOp getImageFilter() {
            return this.bFilter;
        }

        public RasterOp getRasterFilter() {
            return this.rFilter;
        }
    }
}

