/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.goodies.MunchTransform;
import com.sun.glf.util.CompositionComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import javax.swing.JFrame;

public class WaveStroke
implements Stroke {
    private AffineTransform t = new AffineTransform();
    private static final float FLATNESS = 1.0f;
    private static final float DEFAULT_WAVE_LENGTH = 12.0f;
    private static final float DEFAULT_WAVE_AMPLITUDE = 4.0f;
    private static final float DEFAULT_WIDTH = 1.0f;
    private float[] positivePhasePoints = new float[]{1.0f, 2.0f, 3.0f, 2.0f, 5.0f, 2.0f, 6.0f, 0.0f, 7.0f, -2.0f, 9.0f, -2.0f, 11.0f, -2.0f, 12.0f, 0.0f};
    private float[] negativePhasePoints = new float[]{1.0f, -2.0f, 3.0f, -2.0f, 5.0f, -2.0f, 6.0f, 0.0f, 7.0f, 2.0f, 9.0f, 2.0f, 11.0f, 2.0f, 12.0f, 0.0f};
    private float waveLength = 12.0f;
    private float waveAmplitude = 4.0f;
    private float width = 1.0f;
    private BasicStroke basicStroke;

    public WaveStroke(float f) {
        this(f, 12.0f, 4.0f);
    }

    public WaveStroke(float f, float f2, float f3) {
        if (f2 <= 0.0f || f3 <= 0.0f || f <= 0.0f) {
            throw new IllegalArgumentException("Arguments should be greater than zero");
        }
        this.basicStroke = new BasicStroke(f, 0, 2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(f2 / 12.0f, f3 / 4.0f);
        affineTransform.transform(this.positivePhasePoints, 0, this.positivePhasePoints, 0, this.positivePhasePoints.length / 2);
        affineTransform.transform(this.negativePhasePoints, 0, this.negativePhasePoints, 0, this.negativePhasePoints.length / 2);
        this.waveLength = f2;
        this.waveAmplitude = f3;
        this.width = f;
    }

    public Shape createStrokedShape(Shape shape) {
        GeneralPath generalPath;
        MunchTransform munchTransform = new MunchTransform(1.0f);
        PathIterator pathIterator = munchTransform.transform(shape).getPathIterator(null, 1.0);
        float[] fArray = new float[6];
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        AddSegmentControl addSegmentControl = new AddSegmentControl();
        addSegmentControl.s = generalPath = new GeneralPath();
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    addSegmentControl.x = fArray[0];
                    addSegmentControl.y = fArray[1];
                    addSegmentControl.mx = addSegmentControl.x;
                    addSegmentControl.my = addSegmentControl.y;
                    addSegmentControl.start = true;
                    break;
                }
                case 1: {
                    addSegmentControl.dx = fArray[0];
                    addSegmentControl.dy = fArray[1];
                    addSegmentControl.isClose = addSegmentControl.dx == addSegmentControl.mx && addSegmentControl.dy == addSegmentControl.my;
                    this.addSegment(addSegmentControl);
                    addSegmentControl.start = false;
                    addSegmentControl.x = addSegmentControl.dx;
                    addSegmentControl.y = addSegmentControl.dy;
                    break;
                }
                case 4: {
                    addSegmentControl.isClose = true;
                    addSegmentControl.dx = addSegmentControl.mx;
                    addSegmentControl.dy = addSegmentControl.my;
                    this.addSegment(addSegmentControl);
                    addSegmentControl.start = false;
                    addSegmentControl.x = addSegmentControl.mx;
                    addSegmentControl.y = addSegmentControl.my;
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + n);
                }
            }
            pathIterator.next();
        }
        return this.basicStroke.createStrokedShape(generalPath);
    }

    private void addSegment(AddSegmentControl addSegmentControl) {
        float f;
        float f2 = addSegmentControl.x;
        float f3 = addSegmentControl.y;
        float f4 = addSegmentControl.dx;
        float f5 = addSegmentControl.dy;
        GeneralPath generalPath = addSegmentControl.s;
        if (!addSegmentControl.start && addSegmentControl.startOverride) {
            f2 = addSegmentControl.startX;
            f3 = addSegmentControl.startY;
        }
        if (addSegmentControl.start) {
            addSegmentControl.s.moveTo(f2, f3);
        }
        float[] fArray = this.positivePhasePoints;
        if (addSegmentControl.negativePhase) {
            fArray = this.negativePhasePoints;
        }
        if (f2 == f4 && f3 == f5) {
            return;
        }
        float f6 = (float)Point2D.distance(f2, f3, f4, f5);
        double d = Math.atan2(f5 - f3, f4 - f2);
        float f7 = f6 / this.waveLength;
        int n = (int)Math.floor(f7);
        this.t.setToScale(1.0, 1.0);
        this.t.translate(f2, f3);
        float[] fArray2 = new float[fArray.length];
        this.t.rotate(d);
        if (n > 1 && (double)(f7 - (float)n) < 0.5) {
            f = f7 / (float)n;
            this.t.scale(f, 1.0);
            f7 = n;
        }
        this.t.transform(fArray, 0, fArray2, 0, fArray.length / 2);
        f = (f4 - f2) / f7;
        float f8 = (f5 - f3) / f7;
        int n2 = fArray2.length / 4;
        this.t.setToTranslation(f, f8);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                generalPath.quadTo(fArray2[4 * j], fArray2[4 * j + 1], fArray2[4 * j + 2], fArray2[4 * j + 3]);
            }
            this.t.transform(fArray2, 0, fArray2, 0, fArray2.length / 2);
        }
        if (addSegmentControl.isClose) {
            if ((double)(f7 - (float)n) > 0.75) {
                generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                generalPath.quadTo(fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
                generalPath.quadTo(fArray2[8], fArray2[9], fArray2[10], fArray2[11]);
                generalPath.quadTo(fArray2[12], fArray2[13], f4, f5);
                addSegmentControl.startOverride = false;
            } else if ((double)(f7 - (float)n) > 0.25) {
                generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                generalPath.quadTo(fArray2[4], fArray2[5], f4, f5);
                addSegmentControl.negativePhase = !addSegmentControl.negativePhase;
                addSegmentControl.startOverride = false;
            } else {
                generalPath.lineTo(f4, f5);
                addSegmentControl.startOverride = false;
            }
        } else if ((double)(f7 - (float)n) >= 0.5) {
            generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
            generalPath.quadTo(fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
            addSegmentControl.negativePhase = !addSegmentControl.negativePhase;
            addSegmentControl.startOverride = true;
            addSegmentControl.startX = f2 + ((float)n + 0.5f) * f;
            addSegmentControl.startY = f3 + ((float)n + 0.5f) * f8;
        } else {
            addSegmentControl.startOverride = true;
            addSegmentControl.startX = f2 + (float)n * f;
            addSegmentControl.startY = f3 + (float)n * f8;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getWaveLength() {
        return this.waveLength;
    }

    public float getWaveAmplitude() {
        return this.waveAmplitude;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("WaveStroke unit testing");
        jFrame.getContentPane().setBackground(Color.white);
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 100.0, 0.0);
        Rectangle rectangle = new Rectangle(0, 0, 100, 100);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(80.0f, 40.0f);
        generalPath.lineTo(100.0f, 40.0f);
        generalPath.quadTo(100.0f, 100.0f, 140.0f, 160.0f);
        generalPath.lineTo(110.0f, 160.0f);
        generalPath.curveTo(110.0f, 120.0f, 70.0f, 120.0f, 70.0f, 160.0f);
        generalPath.lineTo(40.0f, 160.0f);
        generalPath.quadTo(80.0f, 100.0f, 80.0f, 40.0f);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(50.0f, 0.0f);
        generalPath2.lineTo(100.0f, 100.0f);
        generalPath2.lineTo(0.0f, 100.0f);
        generalPath2.closePath();
        Shape[] shapeArray = new Shape[]{double_, rectangle, double_2, generalPath, generalPath2};
        Stroke[] strokeArray = new Stroke[]{new BasicStroke(), new WaveStroke(3.0f), new WaveStroke(1.0f), new WaveStroke(1.0f, 24.0f, 4.0f), new WaveStroke(3.0f, 12.0f, 8.0f), new WaveStroke(1.0f, 12.0f, 8.0f), new WaveStroke(3.0f, 6.0f, 4.0f)};
        jFrame.getContentPane().setLayout(new GridLayout(0, strokeArray.length));
        for (int i = 0; i < shapeArray.length; ++i) {
            Shape shape = shapeArray[i];
            for (int j = 0; j < strokeArray.length; ++j) {
                WaveStroke.addTestComponent(jFrame, strokeArray[j], shape);
            }
        }
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static void addTestComponent(JFrame jFrame, Stroke stroke, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        LayerComposition layerComposition = new LayerComposition(new Dimension(rectangle.width + 20, rectangle.height + 20));
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, shape, new StrokeRenderer((Paint)Color.gray, stroke), Position.CENTER);
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, shape, new StrokeRenderer((Paint)Color.black, new BasicStroke()), Position.CENTER);
        layerComposition.setBackgroundPaint(Color.white);
        layerComposition.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        layerComposition.setLayers(new Layer[]{shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition));
    }

    static class AddSegmentControl {
        float x;
        float y;
        float dx;
        float dy;
        float mx;
        float my;
        float startX;
        float startY;
        GeneralPath s;
        boolean start;
        boolean negativePhase;
        boolean startOverride;
        boolean isClose;

        AddSegmentControl() {
        }
    }
}

