/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.wsdl;

import com.sun.tools.ws.processor.model.ModelException;
import com.sun.tools.ws.processor.model.java.JavaSimpleType;
import com.sun.tools.ws.processor.model.jaxb.JAXBMapping;
import com.sun.tools.ws.processor.model.jaxb.JAXBModel;
import com.sun.tools.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.ws.processor.modeler.wsdl.ClassNameAllocatorImpl;
import com.sun.tools.ws.processor.util.ClassNameCollector;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.DOMForestScanner;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.LocatorImpl;

public class JAXBModelBuilder {
    private final ErrorReceiver errReceiver;
    private final WsimportOptions options;
    private final MetadataFinder forest;
    private JAXBModel jaxbModel;
    private SchemaCompiler schemaCompiler;
    private final ClassNameAllocatorImpl _classNameAllocator;
    protected static final LocatorImpl NULL_LOCATOR = new LocatorImpl();

    public JAXBModelBuilder(WsimportOptions options, ClassNameCollector classNameCollector, MetadataFinder finder, ErrorReceiver errReceiver) {
        this._classNameAllocator = new ClassNameAllocatorImpl(classNameCollector);
        this.errReceiver = errReceiver;
        this.options = options;
        this.forest = finder;
        this.internalBuildJAXBModel();
    }

    private void internalBuildJAXBModel() {
        try {
            this.schemaCompiler = this.options.getSchemaCompiler();
            this.schemaCompiler.resetSchema();
            this.schemaCompiler.setEntityResolver(this.options.entityResolver);
            this.schemaCompiler.setClassNameAllocator((ClassNameAllocator)this._classNameAllocator);
            this.schemaCompiler.setErrorListener((ErrorListener)this.errReceiver);
            int schemaElementCount = 1;
            for (Element element : this.forest.getInlinedSchemaElement()) {
                String location = element.getOwnerDocument().getDocumentURI();
                String systemId = location + "#types?schema" + schemaElementCount++;
                if (this.forest.isMexMetadata) {
                    this.schemaCompiler.parseSchema(systemId, element);
                    continue;
                }
                new DOMForestScanner(this.forest).scan(element, this.schemaCompiler.getParserHandler(systemId));
            }
            InputSource[] externalBindings = this.options.getSchemaBindings();
            if (externalBindings != null) {
                for (InputSource jaxbBinding : externalBindings) {
                    this.schemaCompiler.parseSchema(jaxbBinding);
                }
            }
        }
        catch (Exception e) {
            throw new ModelException(e);
        }
    }

    public JAXBType getJAXBType(QName qname) {
        JAXBMapping mapping = this.jaxbModel.get(qname);
        if (mapping == null) {
            return null;
        }
        JavaSimpleType javaType = new JavaSimpleType(mapping.getType());
        return new JAXBType(qname, javaType, mapping, this.jaxbModel);
    }

    public TypeAndAnnotation getElementTypeAndAnn(QName qname) {
        JAXBMapping mapping = this.jaxbModel.get(qname);
        if (mapping == null) {
            return null;
        }
        return mapping.getType().getTypeAnn();
    }

    protected void bind() {
        S2JJAXBModel rawJaxbModel = this.schemaCompiler.bind();
        if (rawJaxbModel == null) {
            throw new AbortException();
        }
        this.options.setCodeModel(rawJaxbModel.generateCode(null, (ErrorListener)this.errReceiver));
        this.jaxbModel = new JAXBModel((com.sun.tools.xjc.api.JAXBModel)rawJaxbModel);
        this.jaxbModel.setGeneratedClassNames(this._classNameAllocator.getJaxbGeneratedClasses());
    }

    protected SchemaCompiler getJAXBSchemaCompiler() {
        return this.schemaCompiler;
    }

    public JAXBModel getJAXBModel() {
        return this.jaxbModel;
    }
}

