/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.writers.CyAttributesWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class AttributeSaverState
extends AbstractTableModel {
    public static String newline = System.getProperty("line.separator");
    protected final String suffix;
    private File saveDirectory;
    private int type;
    private Vector<String> attributeNames;
    private Vector<String> filenames;
    private Vector<Boolean> selectedAttributes;
    protected static final int FILE_COLUMN = 2;
    protected static final int ATTRIBUTE_COLUMN = 1;
    protected static final int SAVE_COLUMN = 0;

    public AttributeSaverState(String[] nodeAttributes, String suffix, int type) {
        this.type = type;
        this.suffix = suffix;
        this.attributeNames = new Vector();
        this.filenames = new Vector();
        this.selectedAttributes = new Vector();
        for (int idx = 0; idx < nodeAttributes.length; ++idx) {
            this.attributeNames.add(nodeAttributes[idx]);
        }
        Collections.sort(this.attributeNames);
        for (String attribute : this.attributeNames) {
            this.filenames.add(attribute + suffix);
            this.selectedAttributes.add(new Boolean(false));
        }
    }

    public void setSaveDirectory(File saveDirectory) {
        this.saveDirectory = saveDirectory;
    }

    public int writeState() throws IOException {
        CyAttributes cyAttributes = this.type == 0 ? Cytoscape.getNodeAttributes() : Cytoscape.getEdgeAttributes();
        int count = 0;
        for (int idx = 0; idx < this.attributeNames.size(); ++idx) {
            if (!this.selectedAttributes.get(idx).booleanValue()) continue;
            CyAttributesWriter writer = new CyAttributesWriter(cyAttributes, this.attributeNames.get(idx), new FileWriter(new File(this.saveDirectory, this.filenames.get(idx))));
            writer.writeAttributes();
            ++count;
        }
        return count;
    }

    public boolean saveChecked() {
        for (int i = 0; i < this.selectedAttributes.size(); ++i) {
            if (!this.selectedAttributes.elementAt(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.attributeNames.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.selectedAttributes.get(rowIndex);
            }
            case 1: {
                return this.attributeNames.get(rowIndex);
            }
            case 2: {
                return this.filenames.get(rowIndex);
            }
        }
        throw new IllegalArgumentException();
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Save";
            }
            case 1: {
                return "Attribute";
            }
            case 2: {
                return "Filename";
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 1;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                throw new RuntimeException("Cell is not editable");
            }
            case 0: {
                this.selectedAttributes.set(rowIndex, (Boolean)aValue);
                this.fireTableDataChanged();
                break;
            }
            case 2: {
                this.filenames.set(rowIndex, (String)aValue);
                break;
            }
        }
    }
}

