/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout.ui;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.ui.DynamicLayoutMenu;
import cytoscape.layout.ui.LayoutMenuManager;
import cytoscape.layout.ui.StaticLayoutMenu;
import cytoscape.view.CyNetworkView;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class LayoutMenu
extends JMenu
implements MenuListener {
    List<CyLayoutAlgorithm> subMenuList;

    public LayoutMenu(String menuName) {
        super(menuName);
        this.addMenuListener(this);
        this.subMenuList = new ArrayList<CyLayoutAlgorithm>();
    }

    public void add(CyLayoutAlgorithm layout) {
        this.subMenuList.add(layout);
    }

    public void remove(CyLayoutAlgorithm layout) {
        this.subMenuList.remove(layout);
    }

    public int getItemCount() {
        return this.subMenuList.size();
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        this.removeAll();
        CyNetwork network = Cytoscape.getCurrentNetwork();
        Set selectedNodes = network.getSelectedNodes();
        boolean enableMenuItem = this.checkEnabled();
        for (CyLayoutAlgorithm layout : LayoutMenuManager.getLayoutsInMenu(this.getText())) {
            layout.unlockAllNodes();
            if (layout.supportsNodeAttributes() != null || layout.supportsEdgeAttributes() != null) {
                super.add(new DynamicLayoutMenu(layout, enableMenuItem));
                continue;
            }
            if (layout.supportsSelectedOnly() && selectedNodes.size() > 0) {
                super.add(new DynamicLayoutMenu(layout, enableMenuItem));
                continue;
            }
            super.add(new StaticLayoutMenu(layout, enableMenuItem));
        }
    }

    private boolean checkEnabled() {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        if (network == null || network == Cytoscape.getNullNetwork()) {
            return false;
        }
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        return view != null && view != Cytoscape.getNullNetworkView();
    }
}

