/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

public class MathUtil {
    public static int getExponent(float f) {
        int EXPONENT_MASK = 2139095040;
        int bits = Float.floatToIntBits(f) & 0x7F800000;
        int BIAS = 127;
        int BIT_OFFSET = 23;
        return (bits >> 23) - 127;
    }

    public static long getExponent(double f) {
        long EXPONENT_MASK = 0x7FFFF00000000000L;
        long bits = Double.doubleToLongBits(f) & 0x7FFFF00000000000L;
        int BIAS = 1023;
        int BIT_OFFSET = 52;
        return (bits >> 52) - 1023L;
    }

    public static boolean almostEqual(float x1, float x2) {
        if (x1 == x2) {
            return true;
        }
        if (Math.signum(x1) != Math.signum(x2)) {
            return false;
        }
        if (MathUtil.getExponent(x1) != MathUtil.getExponent(x2)) {
            return false;
        }
        float absX1 = Math.abs(x1);
        float absX2 = Math.abs(x2);
        if (x1 != 0.0f) {
            return Math.abs(x1 - x2) / Math.abs(x1) < 1.0E-6f;
        }
        return Math.abs(x1 - x2) / Math.abs(x2) < 1.0E-6f;
    }

    public static boolean almostEqual(double x1, double x2) {
        if (x1 == x2) {
            return true;
        }
        if (Math.signum(x1) != Math.signum(x2)) {
            return false;
        }
        if (MathUtil.getExponent(x1) != MathUtil.getExponent(x2)) {
            return false;
        }
        double absX1 = Math.abs(x1);
        double absX2 = Math.abs(x2);
        if (x1 != 0.0) {
            return Math.abs(x1 - x2) / Math.abs(x1) < 1.0E-12;
        }
        return Math.abs(x1 - x2) / Math.abs(x2) < 1.0E-12;
    }
}

