/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.data.ImportHandler;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.NNFReader;
import cytoscape.logger.CyLogger;
import cytoscape.util.CyFileFilter;
import java.net.URL;
import java.net.URLConnection;

public class NNFFileFilter
extends CyFileFilter {
    private static String fileNature = ImportHandler.GRAPH_NATURE;
    private static String fileExtension = "nnf";
    private static String[] contentTypes = new String[]{"text/nnf"};
    private static String description = "NNF files";

    public NNFFileFilter() {
        super(fileExtension, description, fileNature);
    }

    public GraphReader getReader(String fileName) {
        this.reader = new NNFReader(fileName);
        return this.reader;
    }

    public GraphReader getReader(URL url, URLConnection conn) {
        try {
            this.reader = new NNFReader(conn.getInputStream(), url.toString());
        }
        catch (Exception e) {
            CyLogger.getLogger(NNFFileFilter.class).error("Unable to get NNF reader: " + e.getMessage());
            this.reader = null;
        }
        return this.reader;
    }
}

