/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.logger.CyLogger;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class CalculatorFactory {
    private static CyLogger logger = CyLogger.getLogger(CalculatorFactory.class);

    public static Calculator newCalculator(String name, Properties calcProps, String baseKey) {
        String typeName = calcProps.getProperty(baseKey + ".visualPropertyType");
        if (typeName == null) {
            return CalculatorFactory.oldSchoolNewCalculator(name, calcProps, baseKey);
        }
        try {
            VisualPropertyType t = VisualPropertyType.valueOf(typeName);
            return new BasicCalculator(name, calcProps, baseKey, t);
        }
        catch (IllegalArgumentException e) {
            logger.info("Couldn't parse visual property type: " + typeName, e);
            return null;
        }
    }

    private static Calculator oldSchoolNewCalculator(String name, Properties calcProps, String baseKey) {
        String className = calcProps.getProperty(baseKey + ".class");
        if (className == null) {
            return null;
        }
        String errString = "CalculatorFactory: error processing baseKey " + baseKey;
        Class<?> realClass = null;
        try {
            realClass = Class.forName(className);
        }
        catch (Exception e) {
            logger.warn(errString + " class not found: " + className);
            return null;
        }
        Class<Calculator> calcClass = Calculator.class;
        if (!calcClass.isAssignableFrom(realClass)) {
            logger.warn(errString + " requested class " + className + " does not implement the Calculator interface");
            return null;
        }
        Class[] parameterTypes = new Class[]{String.class, Properties.class, String.class};
        Constructor constructor = CalculatorFactory.getConstructor(realClass, parameterTypes, className);
        if (constructor == null) {
            logger.warn(errString + " requested constructor for " + className + " could not be created");
            return null;
        }
        Object[] params = new Object[]{name, calcProps, baseKey};
        Calculator calculator = CalculatorFactory.getCalculator(constructor, params, className);
        if (calculator == null) {
            logger.warn(errString + " requested calculator for " + className + " could not be created");
        }
        return calculator;
    }

    private static Constructor getConstructor(Class realClass, Class[] parameterTypes, String className) {
        Constructor constructor = null;
        try {
            constructor = realClass.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            String s = "no suitable constructor found in class " + className;
            logger.warn(s, nsme);
            return null;
        }
        catch (SecurityException se) {
            String s = "could not access constructors for class " + className;
            logger.warn(s, se);
            return null;
        }
        return constructor;
    }

    private static Calculator getCalculator(Constructor constructor, Object[] params, String className) {
        Calculator calculator = null;
        try {
            calculator = (Calculator)constructor.newInstance(params);
        }
        catch (Exception e) {
            String s = "unable to construct an instance of class " + className;
            for (Object p : params) {
                logger.info("-- Parameter = " + p);
            }
            logger.warn(s, e);
            return null;
        }
        return calculator;
    }
}

