/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.AbstractMapping;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.FlatInterpolator;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.continuous.ContinuousLegend;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.mappings.continuous.ContinuousMappingReader;
import cytoscape.visual.mappings.continuous.ContinuousMappingWriter;
import cytoscape.visual.mappings.continuous.ContinuousRangeCalculator;
import cytoscape.visual.parsers.ValueParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousMapping
extends AbstractMapping {
    final Class<?>[] ACCEPTED_CLASS = new Class[]{Number.class};
    private Interpolator interpolator;
    private List<ContinuousMappingPoint> points;

    @Deprecated
    public ContinuousMapping(Object defaultObj, byte mapType) throws IllegalArgumentException {
        this(defaultObj.getClass(), null);
    }

    public ContinuousMapping(Class<?> rangeClass, String controllingAttrName) {
        super(rangeClass, controllingAttrName);
        this.acceptedClasses = this.ACCEPTED_CLASS;
        this.points = new ArrayList<ContinuousMappingPoint>();
        this.interpolator = Color.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToColorInterpolator() : (Number.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToNumberInterpolator() : new FlatInterpolator());
    }

    @Override
    public Object clone() {
        ContinuousMapping clone = new ContinuousMapping(this.rangeClass, this.controllingAttrName);
        for (ChangeListener listener : this.observers) {
            clone.addChangeListener(listener);
        }
        for (ContinuousMappingPoint cmp : this.points) {
            ContinuousMappingPoint cmpClone = (ContinuousMappingPoint)cmp.clone();
            clone.addPoint(cmpClone.getValue(), cmpClone.getRange());
        }
        return clone;
    }

    public List<ContinuousMappingPoint> getAllPoints() {
        return this.points;
    }

    public void addPoint(double value, BoundaryRangeValues brv) {
        ContinuousMappingPoint cmp = new ContinuousMappingPoint(value, brv);
        this.points.add(cmp);
    }

    public void removePoint(int index) {
        this.points.remove(index);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public ContinuousMappingPoint getPoint(int index) {
        return this.points.get(index);
    }

    @Override
    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        ContinuousMappingReader reader = new ContinuousMappingReader(props, baseKey, parser);
        this.points = reader.getPoints();
        this.controllingAttrName = reader.getControllingAttributeName();
        this.interpolator = reader.getInterpolator();
    }

    @Override
    public Properties getProperties(String baseKey) {
        ContinuousMappingWriter writer = new ContinuousMappingWriter(this.points, baseKey, this.controllingAttrName, this.interpolator);
        return writer.getProperties();
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public JPanel getLegend(VisualPropertyType vpt) {
        return new ContinuousLegend(this.points, vpt);
    }

    @Override
    public Object calculateRangeValue(Map<String, Object> attrBundle) {
        ContinuousRangeCalculator calc = new ContinuousRangeCalculator(this.points, this.interpolator, attrBundle);
        return calc.calculateRangeValue(this.controllingAttrName);
    }
}

