/*
 * Decompiled with CFR 0.152.
 */
package giny.view;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Position {
    NORTH_WEST("Northwest", "NW", 0),
    NORTH("North", "N", 1),
    NORTH_EAST("Northeast", "NE", 2),
    WEST("West", "W", 3),
    CENTER("Center", "C", 4),
    EAST("East", "E", 5),
    NONE("none", "NONE", 127),
    SOUTH_WEST("Southwest", "SW", 6),
    SOUTH("South", "S", 7),
    SOUTH_EAST("Southeast", "SE", 8);

    private static final String[] ANCHORS;
    private final String displayName;
    private final String shortName;
    private final int ginyConstatnt;

    private Position(String displayName, String shortName, int ginyConstant) {
        this.displayName = displayName;
        this.shortName = shortName;
        this.ginyConstatnt = ginyConstant;
    }

    public String getName() {
        return this.displayName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getGinyConstant() {
        return this.ginyConstatnt;
    }

    public static Position parse(String value) {
        for (Position p : Position.values()) {
            if (!p.getName().equals(value) && !p.getShortName().equals(value)) continue;
            return p;
        }
        return null;
    }

    public static Position parse(int giny) {
        for (Position p : Position.values()) {
            if (p.getGinyConstant() != giny) continue;
            return p;
        }
        return null;
    }

    public static String[] getNames() {
        return ANCHORS;
    }

    static {
        ANCHORS = new String[]{Position.NORTH_WEST.displayName, Position.NORTH.displayName, Position.NORTH_EAST.displayName, Position.WEST.displayName, Position.CENTER.displayName, Position.EAST.displayName, Position.NONE.displayName, Position.SOUTH_WEST.displayName, Position.SOUTH.displayName, Position.SOUTH_EAST.displayName};
    }
}

