/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import java.io.Serializable;

public final class HistogramUpdate
implements Serializable {
    static final long serialVersionUID = 5574611010721023059L;
    private static final int FINAL_UPDATE = 1;
    public static final int DATA_UPDATE = 2;
    public static final int RANGE_UPDATE = 4;
    public static final int TITLE_UPDATE = 8;
    public static final int RESET = 16;
    private final int AXIS_BASE = 32;
    public final int HORIZONTAL_AXIS = 0;
    public final int VERTICAL_AXIS = 1;
    protected int m_id;

    public HistogramUpdate(int id, boolean f) {
        if (f) {
            id |= 1;
        }
        this.m_id = id;
    }

    public void setAxis(int axisIndex) {
        this.m_id |= 32 << axisIndex;
    }

    public boolean axisIsSet(int axisIndex) {
        return (this.m_id & 32 << axisIndex) != 0;
    }

    public boolean isFinalUpdate() {
        return (this.m_id & 1) != 0;
    }

    public boolean isDataUpdate() {
        return (this.m_id & 2) != 0;
    }

    public boolean isRangeUpdate() {
        return (this.m_id & 4) != 0;
    }

    public boolean isTitleUpdate() {
        return (this.m_id & 8) != 0;
    }

    public boolean isReset() {
        return (this.m_id & 0x10) != 0;
    }

    public String toString() {
        return "HistogramUpdate! " + (this.isDataUpdate() ? "DATA " : "") + (this.isRangeUpdate() ? "RANGE " : "") + (this.isTitleUpdate() ? "TITLE " : "") + (this.isReset() ? "RESET " : "") + (this.isFinalUpdate() ? "FINAL " : "") + (this.axisIsSet(0) ? "HORIZONTAL_AXIS " : "") + (this.axisIsSet(1) ? "VERTICAL_AXIS " : "");
    }
}

