/*
 * Decompiled with CFR 0.152.
 */
package jas.plot.java1;

import jas.plot.SetablePlotGraphics;
import jas.plot.Transformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class PlotGraphics11
implements SetablePlotGraphics {
    private Transformation xt;
    private Transformation yt;
    private Graphics g;
    private Shape oldClip;
    private static final Transformation defaultTransformation = new Transformation(){

        public double convert(double value) {
            return value;
        }
    };
    private int[] ix;
    private int[] iy;
    private int bufSize;

    public void setStroke(Stroke s) {
    }

    public void setGraphics(Graphics g) {
        this.g = g;
        this.oldClip = g == null ? null : g.getClip();
        this.clearTransformation();
    }

    public void setTransformation(Transformation x, Transformation y) {
        this.xt = x == null ? defaultTransformation : x;
        this.yt = y == null ? defaultTransformation : y;
    }

    public void clearTransformation() {
        this.xt = defaultTransformation;
        this.yt = defaultTransformation;
    }

    public void setClip(int xmin, int xmax, int ymin, int ymax) {
        this.g.clipRect(xmin, ymax, xmax - xmin, ymin - ymax);
    }

    public void clearClip() {
        this.g.setClip(this.oldClip);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        int ix1 = (int)this.xt.convert(x1);
        int ix2 = (int)this.xt.convert(x2);
        int iy1 = (int)this.yt.convert(y1);
        int iy2 = (int)this.yt.convert(y2);
        this.g.drawLine(ix1, iy1, ix2, iy2);
    }

    public void drawPolyLine(double[] x, double[] y, int n) {
        this.polyConvert(x, y, n);
        this.g.drawPolyline(this.ix, this.iy, n);
    }

    public void fillRect(double x1, double y1, double x2, double y2) {
        int h;
        int ix1 = (int)this.xt.convert(x1);
        int iy1 = (int)this.yt.convert(y1);
        int ix2 = (int)this.xt.convert(x2);
        int iy2 = (int)this.yt.convert(y2);
        int ixmin = Math.min(ix1, ix2);
        int ixmax = Math.max(ix1, ix2);
        int iymin = Math.min(iy1, iy2);
        int iymax = Math.max(iy1, iy2);
        int w = ixmax - ixmin;
        if ((double)w < 1.0) {
            w = 1;
        }
        if ((double)(h = iymax - iymin) < 1.0) {
            h = 1;
        }
        this.g.fillRect(ixmin, iymin, w, h);
    }

    public void drawRect(double x1, double y1, double x2, double y2) {
        int h;
        int ix1 = (int)this.xt.convert(x1);
        int iy1 = (int)this.yt.convert(y1);
        int ix2 = (int)this.xt.convert(x2);
        int iy2 = (int)this.yt.convert(y2);
        int ixmin = Math.min(ix1, ix2);
        int ixmax = Math.max(ix1, ix2);
        int iymin = Math.min(iy1, iy2);
        int iymax = Math.max(iy1, iy2);
        int w = ixmax - ixmin;
        if ((double)w < 1.0) {
            w = 1;
        }
        if ((double)(h = iymax - iymin) < 1.0) {
            h = 1;
        }
        this.g.drawRect(ixmin, iymin, w, h);
    }

    public void drawOval(double x1, double y1, double x2, double y2) {
        int h;
        int ix1 = (int)this.xt.convert(x1);
        int iy1 = (int)this.yt.convert(y1);
        int ix2 = (int)this.xt.convert(x2);
        int iy2 = (int)this.yt.convert(y2);
        int ixmin = Math.min(ix1, ix2);
        int ixmax = Math.max(ix1, ix2);
        int iymin = Math.min(iy1, iy2);
        int iymax = Math.max(iy1, iy2);
        int w = ixmax - ixmin;
        if ((double)w < 1.0) {
            w = 1;
        }
        if ((double)(h = iymax - iymin) < 1.0) {
            h = 1;
        }
        this.g.drawOval(ixmin, iymin, w, h);
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void drawString(String s, double x, double y) {
        this.g.drawString(s, (int)this.xt.convert(x), (int)this.yt.convert(y));
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public void setFont(Font f) {
        this.g.setFont(f);
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public void drawPolySymbol(double[] x, double[] y, double size, int type, int n) {
        this.polyConvert(x, y, n);
        int is = (int)size;
        for (int i = 0; i < n; ++i) {
            this.drawSymbol(this.ix[i], this.iy[i], is, type);
        }
    }

    public void drawSymbol(double x, double y, double size, int type) {
        int xx = (int)this.xt.convert(x);
        int yy = (int)this.yt.convert(y);
        int is = (int)size;
        this.drawSymbol(xx, yy, is, type);
    }

    public void drawImage(Image image, double x, double y, ImageObserver observer) {
        this.g.drawImage(image, (int)this.xt.convert(x), (int)this.yt.convert(y), observer);
    }

    public void drawImage(Image image, double x, double y, int width, int height, ImageObserver observer) {
        this.g.drawImage(image, (int)this.xt.convert(x), (int)this.yt.convert(y), width, height, observer);
    }

    private void drawSymbol(int x, int y, int is, int type) {
        PlotGraphics11.drawSymbol(this.g, x, y, is, type);
    }

    public static void drawSymbol(Graphics g, int x, int y, int is, int type) {
        int xx = x - is / 2;
        int yy = y - is / 2;
        switch (type) {
            case 0: {
                g.fillOval(xx, yy, is, is);
                break;
            }
            case 1: {
                g.fillRect(xx, yy, is, is);
                break;
            }
            case 2: {
                int[] x3 = new int[]{xx, x, xx + is};
                int[] y3 = new int[]{yy + is, yy, yy + is};
                g.fillPolygon(x3, y3, 3);
                break;
            }
            case 3: {
                int[] x4 = new int[]{xx, x, xx + is, x};
                int[] y4 = new int[]{y, yy + is, y, yy};
                g.fillPolygon(x4, y4, 4);
                break;
            }
            case 4: {
                g.drawLine(xx, y, xx + is, y);
                g.drawLine(xx, yy, xx + is, yy + is);
                g.drawLine(x, yy, x, yy + is);
                g.drawLine(xx, yy + is, xx + is, yy);
                break;
            }
            case 5: {
                g.drawLine(x, yy, x, yy + is);
                break;
            }
            case 6: {
                g.drawLine(xx, y, xx + is, y);
                break;
            }
            case 7: {
                g.drawLine(x, yy, x, yy + is);
                g.drawLine(xx, y, xx + is, y);
                break;
            }
            case 8: {
                g.drawOval(xx, yy, is, is);
                break;
            }
            case 9: {
                g.drawRect(xx, yy, is, is);
            }
        }
    }

    private void polyConvert(double[] x, double[] y, int n) {
        int i;
        if (n > this.bufSize) {
            this.ix = new int[n];
            this.iy = new int[n];
            this.bufSize = n;
        }
        if (this.xt != defaultTransformation) {
            for (i = 0; i < n; ++i) {
                this.ix[i] = (int)this.xt.convert(x[i]);
            }
        } else {
            for (i = 0; i < n; ++i) {
                this.ix[i] = (int)x[i];
            }
        }
        if (this.yt != defaultTransformation) {
            for (i = 0; i < n; ++i) {
                this.iy[i] = (int)this.yt.convert(y[i]);
            }
        } else {
            for (i = 0; i < n; ++i) {
                this.iy[i] = (int)y[i];
            }
        }
    }

    public Rectangle getClipBounds() {
        if (this.g == null) {
            return null;
        }
        return this.g.getClipBounds();
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }
}

