/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLEntryAnnotationChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.TaxonSQL;
import org.biojava.bio.seq.io.OrganismParser;
import org.biojava.bio.taxa.Taxon;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLSequenceAnnotation
implements Annotation {
    private BioSQLSequenceDB seqDB;
    private int bioentry_id;
    private Annotation underlyingAnnotation;

    int getBioentryID() {
        return this.bioentry_id;
    }

    BioSQLSequenceAnnotation(BioSQLSequenceDB seqDB, int bioentry_id) {
        this.seqDB = seqDB;
        this.bioentry_id = bioentry_id;
    }

    private void initAnnotations() {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            this.underlyingAnnotation = new SmallAnnotation();
            this.underlyingAnnotation.setProperty("bioentry_id", new Integer(this.bioentry_id));
            this.initTaxon(conn);
            if (this.seqDB.isBioentryPropertySupported()) {
                PreparedStatement get_properties = conn.prepareStatement("select term.name as qn, bioentry_qualifier_value.value   from bioentry_qualifier_value, term  where bioentry_qualifier_value.bioentry_id = ?    and term.term_id = bioentry_qualifier_value.term_id ");
                get_properties.setInt(1, this.bioentry_id);
                ResultSet rs = get_properties.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(1).trim();
                    String value = rs.getString(2);
                    if (this.underlyingAnnotation.containsProperty(key)) {
                        ArrayList<Object> coll;
                        Object current = this.underlyingAnnotation.getProperty(key);
                        if (!(current instanceof Collection)) {
                            coll = new ArrayList<Object>();
                            coll.add(current);
                            this.underlyingAnnotation.setProperty(key, coll);
                        } else {
                            coll = (ArrayList<Object>)current;
                        }
                        coll.add(value);
                        continue;
                    }
                    this.underlyingAnnotation.setProperty(key, value);
                }
                rs.close();
                get_properties.close();
            }
            conn.close();
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error fetching annotations", ex);
        }
        catch (ChangeVetoException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new BioError(ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initTaxon(Connection conn) {
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            int taxon_id = 0;
            statement = conn.prepareStatement("select taxon_id from bioentry where bioentry_id = ? ");
            statement.setInt(1, this.bioentry_id);
            rs = statement.executeQuery();
            if (rs.next()) {
                taxon_id = rs.getInt(1);
                if (rs.wasNull()) {
                    taxon_id = 0;
                }
            }
            rs.close();
            statement.close();
            if (taxon_id != 0) {
                Taxon taxon = TaxonSQL.getDBTaxon(conn, taxon_id);
                this.underlyingAnnotation.setProperty(OrganismParser.PROPERTY_ORGANISM, taxon);
            }
        }
        catch (ChangeVetoException ex) {
            try {
                throw new BioRuntimeException("Couldn't manipulate in-memory taxonomy", ex);
                catch (SQLException ex2) {
                    throw new BioRuntimeException("Error fetching taxonomy annotations", ex2);
                }
            }
            catch (Throwable throwable) {
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(statement);
                throw throwable;
            }
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(statement);
    }

    public Object getProperty(Object key) {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(Object key, Object value) throws ChangeVetoException {
        BioSQLEntryAnnotationChangeHub entryAnnotationHub;
        BioSQLEntryAnnotationChangeHub bioSQLEntryAnnotationChangeHub = entryAnnotationHub = this.seqDB.getEntryAnnotationChangeHub();
        synchronized (bioSQLEntryAnnotationChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, Annotation.PROPERTY, key);
            entryAnnotationHub.firePreChange(cev);
            this._setProperty(key, value);
            entryAnnotationHub.firePostChange(cev);
        }
    }

    private void _setProperty(Object key, Object value) throws ChangeVetoException {
        this.persistProperty(key, value);
        if (this.underlyingAnnotation != null) {
            this.underlyingAnnotation.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(Object key) throws ChangeVetoException {
        BioSQLEntryAnnotationChangeHub entryAnnotationHub;
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        if (!this.underlyingAnnotation.containsProperty(key)) {
            throw new NoSuchElementException("Annotation doesn't contain property " + key.toString());
        }
        BioSQLEntryAnnotationChangeHub bioSQLEntryAnnotationChangeHub = entryAnnotationHub = this.seqDB.getEntryAnnotationChangeHub();
        synchronized (bioSQLEntryAnnotationChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, Annotation.PROPERTY, key);
            entryAnnotationHub.firePreChange(cev);
            this.underlyingAnnotation.removeProperty(key);
            this.persistProperty(key, null);
            entryAnnotationHub.firePostChange(cev);
        }
    }

    private void persistProperty(Object key, Object value) throws ChangeVetoException {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            conn.setAutoCommit(false);
            this.seqDB.persistBioentryProperty(conn, this.bioentry_id, key, value, true, false);
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error adding to BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    public boolean containsProperty(Object key) {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.containsProperty(key);
    }

    public Set keys() {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.keys();
    }

    public Map asMap() {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return Collections.unmodifiableMap(this.underlyingAnnotation.asMap());
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.seqDB.getEntryAnnotationChangeHub().addListener(new Integer(this.bioentry_id), cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.seqDB.getEntryAnnotationChangeHub().removeListener(new Integer(this.bioentry_id), cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        return false;
    }
}

