/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;

public class JDBCConnectionPool {
    private final String dbURL;
    private final String dbUser;
    private final String dbPass;
    private LinkedList connectionPool = new LinkedList();

    public JDBCConnectionPool(String url, String user, String pass) {
        this.dbURL = url;
        this.dbUser = user;
        this.dbPass = pass;
    }

    public JDBCConnectionPool(String url) {
        this(url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection takeConnection() throws SQLException {
        Connection conn = null;
        LinkedList linkedList = this.connectionPool;
        synchronized (linkedList) {
            if (this.connectionPool.size() > 0) {
                conn = (Connection)this.connectionPool.removeFirst();
            }
        }
        conn = this.dbUser != null ? DriverManager.getConnection(this.dbURL, this.dbUser, this.dbPass) : DriverManager.getConnection(this.dbURL);
        Statement st = conn.createStatement();
        st.close();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnection(Connection c) throws SQLException {
        if (!c.isClosed()) {
            LinkedList linkedList = this.connectionPool;
            synchronized (linkedList) {
                this.connectionPool.addLast(c);
            }
        }
    }

    public Statement takeStatement() throws SQLException {
        return this.takeConnection().createStatement();
    }

    public void putStatement(Statement st) throws SQLException {
        this.putConnection(st.getConnection());
        st.close();
    }
}

