/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.equations.EqnCompiler;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.Parser;
import org.cytoscape.equations.interpreter.IdentDescriptor;
import org.cytoscape.equations.interpreter.Interpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Framework {
    private static final EqnCompiler compiler = new EqnCompiler();

    Framework() {
    }

    static boolean executeTest(String equation, Map<String, Object> variablesAndValues, Object expectedResult) {
        Object actualResult;
        HashMap<String, Class> varNameToTypeMap = new HashMap<String, Class>();
        for (String variableName : variablesAndValues.keySet()) {
            varNameToTypeMap.put(variableName, variablesAndValues.get(variableName).getClass());
        }
        try {
            if (!compiler.compile(equation, varNameToTypeMap)) {
                System.err.println("Error while compiling \"" + equation + "\": " + compiler.getLastErrorMsg());
                return false;
            }
        }
        catch (Exception e) {
            System.err.println("Error while compiling \"" + equation + "\": " + e.getMessage());
            return false;
        }
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        try {
            for (String variableName : variablesAndValues.keySet()) {
                nameToDescriptorMap.put(variableName, new IdentDescriptor(variablesAndValues.get(variableName)));
            }
        }
        catch (Exception e) {
            System.err.println("Error while processing variables for \"" + equation + "\": " + e.getMessage());
            return false;
        }
        Interpreter interpreter = new Interpreter(compiler.getEquation(), nameToDescriptorMap);
        try {
            actualResult = interpreter.run();
        }
        catch (Exception e) {
            System.err.println("caught runtime error: " + e.getMessage());
            return false;
        }
        if (!Framework.areEqual(actualResult, expectedResult)) {
            System.err.println("[" + equation + "] expected: " + expectedResult + ", found: " + actualResult);
            return false;
        }
        return true;
    }

    static boolean executeTest(String equation, Object expectedResult) {
        HashMap<String, Object> variablesAndValues = new HashMap<String, Object>();
        return Framework.executeTest(equation, variablesAndValues, expectedResult);
    }

    static boolean executeTestExpectFailure(String equation, Map<String, Object> variablesAndValues) {
        HashMap<String, Class> varNameToTypeMap = new HashMap<String, Class>();
        for (String variableName : variablesAndValues.keySet()) {
            varNameToTypeMap.put(variableName, variablesAndValues.get(variableName).getClass());
        }
        try {
            if (!compiler.compile(equation, varNameToTypeMap)) {
                System.err.println("Error while compiling \"" + equation + "\": " + compiler.getLastErrorMsg());
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error while compiling \"" + equation + "\": " + e.getMessage());
            return true;
        }
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        try {
            for (String variableName : variablesAndValues.keySet()) {
                nameToDescriptorMap.put(variableName, new IdentDescriptor(variablesAndValues.get(variableName)));
            }
        }
        catch (Exception e) {
            System.err.println("Error while processing variables for \"" + equation + "\": " + e.getMessage());
            return true;
        }
        Interpreter interpreter = new Interpreter(compiler.getEquation(), nameToDescriptorMap);
        try {
            Object result = interpreter.run();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    static boolean executeTestExpectFailure(String equation) {
        HashMap<String, Object> variablesAndValues = new HashMap<String, Object>();
        return Framework.executeTestExpectFailure(equation, variablesAndValues);
    }

    private static long getExponent(double f) {
        long EXPONENT_MASK = 0x7FFFF00000000000L;
        long bits = Double.doubleToLongBits(f) & 0x7FFFF00000000000L;
        int BIAS = 1023;
        int BIT_OFFSET = 52;
        return (bits >> 52) - 1023L;
    }

    private static boolean almostEqual(double x1, double x2) {
        if (x1 == x2) {
            return true;
        }
        if (Math.signum(x1) != Math.signum(x2)) {
            return false;
        }
        if (Framework.getExponent(x1) != Framework.getExponent(x2)) {
            return false;
        }
        double absX1 = Math.abs(x1);
        double absX2 = Math.abs(x2);
        if (x1 != 0.0) {
            return Math.abs(x1 - x2) / Math.abs(x1) < 1.0E-12;
        }
        return Math.abs(x1 - x2) / Math.abs(x2) < 1.0E-12;
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 instanceof Double && o2 instanceof Double) {
            return Framework.almostEqual((Double)o1, (Double)o2);
        }
        if (o1 instanceof List && o2 instanceof List) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (Framework.areEqual(l1.get(i), l2.get(i))) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    static {
        Parser.getParser().registerFunction(new BadReturnFunction());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BadReturnFunction
    implements Function {
        private BadReturnFunction() {
        }

        @Override
        public String getName() {
            return "BAD";
        }

        @Override
        public String getFunctionSummary() {
            return "Returns an invalid type at runtime.";
        }

        @Override
        public String getUsageDescription() {
            return "Call this with \"BAD()\".";
        }

        @Override
        public Class getReturnType() {
            return Double.class;
        }

        @Override
        public Class validateArgTypes(Class[] argTypes) {
            return argTypes.length == 0 ? Double.class : null;
        }

        @Override
        public Object evaluateFunction(Object[] args) {
            return new Integer(1);
        }

        @Override
        public List<Class> getPossibleArgTypes(Class[] leadingArgs) {
            return null;
        }
    }
}

