/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.interpreter.Instruction;
import org.cytoscape.equations.parse_tree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentNode
extends Node {
    private final String attribName;
    private final Object defaultValue;
    private final Class type;

    public IdentNode(int sourceLocation, String attribName, Object defaultValue, Class type) {
        super(sourceLocation);
        if (type == null) {
            throw new IllegalArgumentException("\"type\" must not be null!");
        }
        if (defaultValue != null && defaultValue.getClass() != type) {
            throw new IllegalArgumentException("default value must match \"type\"!");
        }
        this.attribName = attribName;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    @Override
    public String toString() {
        return "IdentNode: " + this.attribName + (this.defaultValue == null ? "" : " default=" + this.defaultValue);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Node getLeftChild() {
        return null;
    }

    @Override
    public Node getRightChild() {
        return null;
    }

    public String getAttribName() {
        return this.attribName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        if (this.defaultValue != null) {
            codeStack.push(new CodeAndSourceLocation(this.defaultValue, -1));
        }
        codeStack.push(new CodeAndSourceLocation(this.attribName, -1));
        codeStack.push(new CodeAndSourceLocation((Object)(this.defaultValue == null ? Instruction.AREF : Instruction.AREF2), this.getSourceLocation()));
    }
}

