/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.FastaReader;
import cn.bgi.PsmPool;
import cn.bgi.Spectra;
import cn.bgi.ValueComparator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class FDRcalculator {
    private static double confidentFilter = 0.01;
    private static String outFileName;
    private static String fasta;
    private static String decoyString;
    private static boolean reMap;

    static {
        reMap = false;
    }

    public static String getDecoyString() {
        return decoyString;
    }

    public static void setDecoyString(String decoyString) {
        FDRcalculator.decoyString = decoyString;
    }

    public static void initialize(boolean reMap, double qvalueFilter, String outFileName, String fasta) {
        FDRcalculator.reMap = reMap;
        confidentFilter = qvalueFilter;
        FDRcalculator.outFileName = outFileName;
        FDRcalculator.fasta = fasta;
    }

    public static void main(String[] args) throws Exception {
    }

    public static HashSet<String> fdrCalc(PsmPool psmPool) throws IOException, InterruptedException, ExecutionException {
        double score;
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(dateformat.format(new Date()));
        System.out.println("Begin FDR calculation ...");
        HashSet<String> confidentPSMIDHashSet = new HashSet<String>();
        if (reMap) {
            System.out.println(dateformat.format(new Date()));
            System.out.println("Re-map peptides to proteins ...");
            FastaReader fastaReader = new FastaReader(fasta, ">", true);
            HashMap pepCache = new HashMap();
            for (String spectraIndex : psmPool.getPsm().keySet()) {
                boolean bl;
                Spectra psm2 = psmPool.getPsm().get(spectraIndex);
                if (psm2.isDecoy()) continue;
                if (pepCache.containsKey(psm2.getPepSeq().toUpperCase())) {
                    psm2.setProString((String)((ArrayList)pepCache.get(psm2.getPepSeq().toUpperCase())).get(0));
                    psm2.setPosString((String)((ArrayList)pepCache.get(psm2.getPepSeq().toUpperCase())).get(1));
                } else {
                    String[] tmpStrings = fastaReader.getMapProteinIDThread2(psm2.getPepSeq().toUpperCase());
                    psm2.setProString(tmpStrings[0]);
                    psm2.setPosString(tmpStrings[1]);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(tmpStrings[0]);
                    arrayList.add(tmpStrings[1]);
                    pepCache.put(psm2.getPepSeq().toUpperCase(), arrayList);
                }
                boolean isDecoy = false;
                boolean bl2 = true;
                String[] stringArray = psm2.getProString().split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String acc = stringArray[n2];
                    if (!acc.startsWith(Spectra.getSapPrefixString())) {
                        bl = false;
                    }
                    if (acc.startsWith(Spectra.getDecoyPrefixString())) {
                        isDecoy = true;
                    }
                    ++n2;
                }
                psm2.setSAP(bl);
            }
        }
        System.out.println(dateformat.format(new Date()));
        System.out.println("Sort PSMs according to e-value ...");
        ValueComparator bvc = new ValueComparator(psmPool.getPsm());
        TreeMap<Object, Spectra> sorted_map = new TreeMap<Object, Spectra>(bvc);
        sorted_map.putAll(psmPool.getPsm());
        System.out.println(sorted_map.size());
        HashMap varDecoyPSMnBelowScore = new HashMap();
        HashMap decoyPSMnBelowScore = new HashMap();
        HashMap<String, Integer> charge2varDecoyN = new HashMap<String, Integer>();
        HashMap<String, Integer> charge2DecoyN = new HashMap<String, Integer>();
        for (String string : psmPool.getCharge2lastPSM().keySet()) {
            varDecoyPSMnBelowScore.put(string, new HashMap());
            decoyPSMnBelowScore.put(string, new HashMap());
            charge2varDecoyN.put(string, 0);
            charge2DecoyN.put(string, 0);
        }
        for (String string : sorted_map.descendingKeySet()) {
            Spectra psm3 = psmPool.getPsm().get(string);
            double score2 = psm3.getScore();
            String chargeClass3 = psm3.getChargeClass();
            if (psm3.isDecoy()) {
                charge2DecoyN.put(chargeClass3, (Integer)charge2DecoyN.get(chargeClass3) + 1);
                if (!psm3.isAnyProFromDecoySAP()) continue;
                charge2varDecoyN.put(chargeClass3, (Integer)charge2varDecoyN.get(chargeClass3) + 1);
                continue;
            }
            ((HashMap)decoyPSMnBelowScore.get(chargeClass3)).put(score2, (Integer)charge2DecoyN.get(chargeClass3));
            if (!psm3.isSap()) continue;
            ((HashMap)varDecoyPSMnBelowScore.get(chargeClass3)).put(score2, (Integer)charge2varDecoyN.get(chargeClass3));
        }
        HashMap hashMap = new HashMap();
        HashMap varDecoyPSMnAboveScore = new HashMap();
        HashMap norDecoyPSMnAboveScore = new HashMap();
        HashMap targetPSMnAboveScore = new HashMap();
        HashMap decoyPSMnAboveScore = new HashMap();
        HashMap<String, Integer> charge2varTargetNaboveScore = new HashMap<String, Integer>();
        HashMap<String, Integer> charge2varDecoyNaboveScore = new HashMap<String, Integer>();
        HashMap<String, Integer> charge2norDecoyNaboveScore = new HashMap<String, Integer>();
        HashMap<String, Integer> charge2TargetNaboveScore = new HashMap<String, Integer>();
        HashMap<String, Integer> charge2DecoyNaboveScore = new HashMap<String, Integer>();
        for (String chargeClass4 : psmPool.getCharge2lastPSM().keySet()) {
            hashMap.put(chargeClass4, new HashMap());
            targetPSMnAboveScore.put(chargeClass4, new HashMap());
            charge2varTargetNaboveScore.put(chargeClass4, 0);
            charge2TargetNaboveScore.put(chargeClass4, 0);
            varDecoyPSMnAboveScore.put(chargeClass4, new HashMap());
            norDecoyPSMnAboveScore.put(chargeClass4, new HashMap());
            decoyPSMnAboveScore.put(chargeClass4, new HashMap());
            charge2varDecoyNaboveScore.put(chargeClass4, 0);
            charge2DecoyNaboveScore.put(chargeClass4, 0);
            charge2norDecoyNaboveScore.put(chargeClass4, 0);
        }
        int totalDecoyVarPSM = 0;
        int totalDecoyPSM = 0;
        for (String string : sorted_map.keySet()) {
            Spectra spectra = psmPool.getPsm().get(string);
            score = spectra.getScore();
            String string2 = spectra.getChargeClass();
            if (!spectra.isDecoy()) {
                if (spectra.isSap()) {
                    charge2varTargetNaboveScore.put(string2, (Integer)charge2varTargetNaboveScore.get(string2) + 1);
                    ((HashMap)hashMap.get(string2)).put(score, (Integer)charge2varTargetNaboveScore.get(string2));
                } else {
                    charge2TargetNaboveScore.put(string2, (Integer)charge2TargetNaboveScore.get(string2) + 1);
                    ((HashMap)targetPSMnAboveScore.get(string2)).put(score, (Integer)charge2TargetNaboveScore.get(string2));
                    ((HashMap)norDecoyPSMnAboveScore.get(string2)).put(score, (Integer)charge2norDecoyNaboveScore.get(string2));
                }
                ((HashMap)decoyPSMnAboveScore.get(string2)).put(score, (Integer)charge2DecoyNaboveScore.get(string2));
                continue;
            }
            ++totalDecoyPSM;
            charge2DecoyNaboveScore.put(string2, (Integer)charge2DecoyNaboveScore.get(string2) + 1);
            if (spectra.isDecoySAP()) {
                ++totalDecoyVarPSM;
                charge2varDecoyNaboveScore.put(string2, (Integer)charge2varDecoyNaboveScore.get(string2) + 1);
                continue;
            }
            charge2norDecoyNaboveScore.put(string2, (Integer)charge2norDecoyNaboveScore.get(string2) + 1);
        }
        System.out.println(dateformat.format(new Date()));
        System.out.println("First round FDR calculation ...");
        for (String string : sorted_map.keySet()) {
            Spectra spectra = psmPool.getPsm().get(string);
            score = spectra.getScore();
            String string3 = spectra.getChargeClass();
            if (spectra.isDecoy()) continue;
            double fdr = 0.0;
            if (spectra.isSap()) {
                double Tvplus;
                double D;
                double Dv;
                double Dplus = ((Integer)((HashMap)decoyPSMnAboveScore.get(string3)).get(score)).intValue();
                fdr = 1.0 * Dplus * (1.0 * (Dv = (double)totalDecoyVarPSM) / (D = (double)totalDecoyPSM)) / (Tvplus = (double)((Integer)((HashMap)hashMap.get(string3)).get(score)).intValue());
                if (fdr > 1.0) {
                    fdr = 1.0;
                }
                System.out.println(String.valueOf(spectra.getChargeClass()) + "," + spectra.getScore() + ",Dplus=" + Dplus + ",Dv=" + Dv + ",D=" + D + ",Tvplus=" + Tvplus + ",fdr=" + fdr);
            } else {
                int tn = (Integer)((HashMap)targetPSMnAboveScore.get(string3)).get(score);
                int fn = (Integer)((HashMap)norDecoyPSMnAboveScore.get(string3)).get(score);
                fdr = 1.0 * (double)fn / (double)tn;
            }
            spectra.setFDR(fdr);
            spectra.setQvalue(fdr);
        }
        System.out.println(dateformat.format(new Date()));
        System.out.println("First round q-value calculation ...");
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        HashMap<String, Double> minFDR4varPep = new HashMap<String, Double>();
        for (String string : psmPool.getCharge2lastPSM().keySet()) {
            hashMap2.put(string, 1.0);
            minFDR4varPep.put(string, 1.0);
        }
        for (String string : sorted_map.descendingKeySet()) {
            Spectra psm4 = psmPool.getPsm().get(string);
            String string4 = psm4.getChargeClass();
            if (psm4.isDecoy()) continue;
            if (psm4.isSap()) {
                if ((Double)minFDR4varPep.get(string4) < psm4.getFDR()) {
                    psm4.setQvalue((Double)minFDR4varPep.get(string4));
                    continue;
                }
                minFDR4varPep.put(string4, psm4.getFDR());
                continue;
            }
            if ((Double)hashMap2.get(string4) < psm4.getFDR()) {
                psm4.setQvalue((Double)hashMap2.get(string4));
                continue;
            }
            hashMap2.put(string4, psm4.getFDR());
        }
        System.out.println(dateformat.format(new Date()));
        System.out.println("Output to file " + outFileName + " ...");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(outFileName)));
        bufferedWriter.write(String.valueOf(Spectra.getOutHead()) + "\n");
        int sumIdentPSMs = 0;
        HashSet<String> uniquePeptideSeqSet = new HashSet<String>();
        for (String string : sorted_map.keySet()) {
            Spectra psm5 = psmPool.getPsm().get(string);
            if (psm5.isDecoy() || !(psm5.getQvalue() <= confidentFilter)) continue;
            bufferedWriter.write(String.valueOf(psm5.getOutLine()) + "\n");
            ++sumIdentPSMs;
            uniquePeptideSeqSet.add(psm5.getPepSeq());
            if (!psm5.isSap()) continue;
            confidentPSMIDHashSet.add(psm5.getIndex());
        }
        bufferedWriter.close();
        int[] nArray = new int[]{sumIdentPSMs, uniquePeptideSeqSet.size()};
        System.out.println("Number of identified PSMs: " + nArray[0] + ", " + "number of identified peptides: " + nArray[1]);
        return confidentPSMIDHashSet;
    }
}

