/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FastaReader {
    public String fasta_file;
    public String tag = ">";
    public static String decoyString = "###REV###";
    private static int cpu = 1;
    public HashMap<String, String> proteinID2seq = new HashMap();
    public ArrayList<String> accArrayList = new ArrayList();
    public ArrayList<String> proseqArrayList = new ArrayList();
    private ArrayList<String> mapedAccArrayList = new ArrayList();

    public FastaReader(String fasta_file, String tag, boolean cpu) throws FileNotFoundException {
        this.fasta_file = fasta_file;
        this.tag = tag;
        if (cpu) {
            this.readFastaFile2();
        } else {
            this.readFastaFile();
        }
    }

    public String[] getMapProteinIDThread(String pepseqString) {
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (String accString : this.proteinID2seq.keySet()) {
            fixedThreadPool.submit(new getSingleMap(this.proteinID2seq.get(accString), accString, pepseqString));
        }
        fixedThreadPool.shutdown();
        Pattern pattern = Pattern.compile(pepseqString);
        StringBuilder idBuilder = new StringBuilder();
        StringBuilder posBuilder = new StringBuilder();
        for (String accString : this.mapedAccArrayList) {
            String proteinSeqString = this.proteinID2seq.get(accString);
            Matcher m = pattern.matcher(proteinSeqString);
            while (m.find()) {
                if (idBuilder.length() == 0) {
                    idBuilder.append(accString);
                    posBuilder.append(m.start() + 1);
                    posBuilder.append(":");
                    posBuilder.append(m.end());
                    continue;
                }
                idBuilder.append(";");
                idBuilder.append(accString);
                posBuilder.append(";");
                posBuilder.append(m.start() + 1);
                posBuilder.append(":");
                posBuilder.append(m.end());
            }
        }
        String[] out = new String[]{idBuilder.toString(), posBuilder.toString()};
        return out;
    }

    public String[] getMapProteinIDThread2(String pepseqString) throws InterruptedException, ExecutionException {
        int cpun = 1;
        cpun = cpu == 0 ? Runtime.getRuntime().availableProcessors() : cpu;
        if (this.accArrayList.size() <= 1000) {
            cpun = 1;
        }
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(cpun);
        ExecutorCompletionService<HashMap<String, String>> cService = new ExecutorCompletionService<HashMap<String, String>>(fixedThreadPool);
        int npro = (int)Math.floor(1.0 * (double)this.accArrayList.size() / (double)cpun);
        int start = 0;
        int end = -1;
        int i = 1;
        while (i <= cpun) {
            start = end + 1;
            end = i == cpun ? this.accArrayList.size() : start + npro;
            cService.submit(new getSingleMap2(this.accArrayList.subList(start, end), this.proseqArrayList.subList(start, end), pepseqString));
            ++i;
        }
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> posList = new ArrayList<String>();
        int i2 = 1;
        while (i2 <= cpun) {
            Future future = cService.take();
            if (!((HashMap)future.get()).isEmpty()) {
                for (String key : ((HashMap)future.get()).keySet()) {
                    idList.add(key);
                    posList.add((String)((HashMap)future.get()).get(key));
                }
            }
            ++i2;
        }
        fixedThreadPool.shutdown();
        if (idList.size() == 0) {
            System.err.println(String.valueOf(pepseqString) + " is not matched to any protein!");
            System.exit(0);
        }
        String idOut = StringUtils.join(idList, ";");
        String posOut = StringUtils.join(posList, ";");
        String[] out = new String[]{idOut, posOut};
        return out;
    }

    public String[] getMapProteinID(String pepseqString) {
        Pattern pattern = Pattern.compile(pepseqString);
        StringBuilder idBuilder = new StringBuilder();
        StringBuilder posBuilder = new StringBuilder();
        for (String accString : this.proteinID2seq.keySet()) {
            String proteinSeqString = this.proteinID2seq.get(accString);
            Matcher m = pattern.matcher(proteinSeqString);
            while (m.find()) {
                if (idBuilder.length() == 0) {
                    idBuilder.append(accString);
                    posBuilder.append(m.start() + 1);
                    posBuilder.append(":");
                    posBuilder.append(m.end());
                    continue;
                }
                idBuilder.append(";");
                idBuilder.append(accString);
                posBuilder.append(";");
                posBuilder.append(m.start() + 1);
                posBuilder.append(":");
                posBuilder.append(m.end());
            }
        }
        String[] out = new String[]{idBuilder.toString(), posBuilder.toString()};
        return out;
    }

    public void readFastaFile() throws FileNotFoundException {
        if (this.fasta_file != null) {
            Scanner dbPro = new Scanner(new File(this.fasta_file));
            dbPro.useDelimiter(">");
            String proID = null;
            int num = 0;
            while (dbPro.hasNext()) {
                String proLine = dbPro.next();
                proLine = proLine.replaceAll("\r", "");
                String[] proInfo = proLine.split("\n");
                if (proID == null) {
                    proID = proInfo[0].split("\\s")[0];
                    ++num;
                }
                if (proInfo.length == 1 || proInfo[0].startsWith(decoyString)) {
                    proID = null;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                int i = 1;
                while (i < proInfo.length) {
                    stringBuilder.append(proInfo[i]);
                    ++i;
                }
                this.proteinID2seq.put(proID, stringBuilder.toString().toUpperCase());
                proID = null;
            }
            dbPro.close();
            System.out.println("Read " + num + " protein sequences!");
        }
    }

    public static String getDecoyString() {
        return decoyString;
    }

    public static void setDecoyString(String decoyString) {
        FastaReader.decoyString = decoyString;
    }

    public void readFastaFile2() throws FileNotFoundException {
        if (this.fasta_file != null) {
            Scanner dbPro = new Scanner(new File(this.fasta_file));
            dbPro.useDelimiter(">");
            String proID = null;
            int num = 0;
            while (dbPro.hasNext()) {
                String proLine = dbPro.next();
                proLine = proLine.replaceAll("\r", "");
                String[] proInfo = proLine.split("\n");
                if (proID == null) {
                    proID = proInfo[0].split("\\s")[0];
                    ++num;
                }
                if (proInfo.length == 1 || proInfo[0].startsWith(decoyString)) {
                    proID = null;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                int i = 1;
                while (i < proInfo.length) {
                    stringBuilder.append(proInfo[i]);
                    ++i;
                }
                this.accArrayList.add(proID);
                this.proseqArrayList.add(stringBuilder.toString().toUpperCase());
                proID = null;
            }
            dbPro.close();
            System.out.println("Read " + num + " protein sequences!");
        }
    }

    public ArrayList<String> getMapedAccArrayList() {
        return this.mapedAccArrayList;
    }

    synchronized void addMapedAccArrayList(String accString) {
        this.mapedAccArrayList.add(accString);
    }

    public static int getCpu() {
        return cpu;
    }

    public static void setCpu(int cpu) {
        FastaReader.cpu = cpu > Runtime.getRuntime().availableProcessors() || cpu <= 0 ? Runtime.getRuntime().availableProcessors() : cpu;
    }

    public class getSingleMap
    implements Runnable {
        private String proteinSeqString;
        private String accString;
        private String pepseq;

        public getSingleMap(String proteinSeqString, String accString, String pepString) {
            this.proteinSeqString = proteinSeqString;
            this.pepseq = pepString;
            this.accString = accString;
        }

        @Override
        public void run() {
            if (this.proteinSeqString.contains(this.pepseq)) {
                FastaReader.this.addMapedAccArrayList(this.accString);
            }
        }
    }

    public class getSingleMap2
    implements Callable<HashMap<String, String>> {
        private String pepseq;
        private List<String> accList = new ArrayList<String>();
        private List<String> proseqList = new ArrayList<String>();

        public getSingleMap2(List<String> a, List<String> b, String pepString) {
            this.accList = a;
            this.proseqList = b;
            this.pepseq = pepString;
        }

        @Override
        public HashMap<String, String> call() {
            Pattern pattern = Pattern.compile(this.pepseq);
            StringBuilder idBuilder = new StringBuilder();
            StringBuilder posBuilder = new StringBuilder();
            int i = 0;
            while (i < this.accList.size()) {
                String proteinSeqString = this.proseqList.get(i);
                String accString = this.accList.get(i);
                Matcher m = pattern.matcher(proteinSeqString);
                while (m.find()) {
                    if (idBuilder.length() == 0) {
                        idBuilder.append(accString);
                        posBuilder.append(m.start() + 1);
                        posBuilder.append(":");
                        posBuilder.append(m.end());
                        continue;
                    }
                    idBuilder.append(";");
                    idBuilder.append(accString);
                    posBuilder.append(";");
                    posBuilder.append(m.start() + 1);
                    posBuilder.append(":");
                    posBuilder.append(m.end());
                }
                ++i;
            }
            HashMap<String, String> outHashMap = new HashMap<String, String>();
            if (!idBuilder.toString().isEmpty()) {
                outHashMap.put(idBuilder.toString(), posBuilder.toString());
            }
            return outHashMap;
        }
    }
}

