/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.script;

import com.compomics.mascotdatfile.research.util.DatfileLocation;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.PeptideHitAnnotation;
import com.compomics.mascotdatfile.util.mascot.ProteinHit;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DrawSpectrum {
    private static Logger logger = Logger.getLogger(DrawSpectrum.class);

    public static void main(String[] args) {
        DatfileLocation lDatfileLocation = null;
        MascotDatfileInf lMascotDatfile = null;
        int lQueryNumber = Integer.parseInt(args[2]);
        int lPeptideHitNumber = Integer.parseInt(args[3]);
        int lDatfileLocationType = Integer.parseInt(args[0]);
        try {
            if (lDatfileLocationType == 0) {
                lDatfileLocation = new DatfileLocation(0, new String[]{args[1]});
                lMascotDatfile = lDatfileLocation.getDatfile();
            } else if (lDatfileLocationType == 1) {
                lDatfileLocation = new DatfileLocation(1, new String[]{args[4], args[5], args[1]});
                lMascotDatfile = lDatfileLocation.getDatfile();
            }
            System.out.println("Datfile received.");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        QueryToPeptideMapInf QueryTP = lMascotDatfile.getQueryToPeptideMap();
        PeptideHit ph = QueryTP.getPeptideHitOfOneQuery(lQueryNumber, lPeptideHitNumber);
        Vector queries = lMascotDatfile.getQueryList();
        Query q = (Query)queries.get(lQueryNumber - 1);
        if (ph == null) {
            throw new NullPointerException("The peptidehit you requested has evoked a nullpointerException. This means that there was no peptidehit in the requested query.");
        }
        ArrayList lProteinHits = ph.getProteinHits();
        ProteinHit ProteinHit2 = (ProteinHit)lProteinHits.get(0);
        System.out.println("Showing spectrum from " + lDatfileLocation + " Datfile " + args[1] + ", Query " + lQueryNumber + ", Peptidehit " + lPeptideHitNumber + ":\t" + ph.getModifiedSequence() + "\n" + lMascotDatfile.getProteinMap().getProteinDescription(ProteinHit2.getAccession()));
        PeptideHitAnnotation pha = ph.getPeptideHitAnnotation(lMascotDatfile.getMasses(), lMascotDatfile.getParametersSection(), q.getPrecursorMZ(), q.getChargeString());
        Vector fm = pha.getMatchedIonsByMascot(q.getPeakList(), ph.getPeaksUsedFromIons1());
        SpectrumPanel sp1 = new SpectrumPanel(q.getMZArray(), q.getIntensityArray(), q.getPrecursorMZ(), q.getChargeString(), q.getTitle());
        sp1.setAnnotations(fm);
        JFrame app1 = new JFrame("Spectrum for " + q.getTitle() + " - " + ph.getModifiedSequence() + " (Mascot ions)" + " - " + "Score: " + ph.getIonsScore());
        app1.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        app1.getContentPane().add(sp1);
        app1.setLocation(100, 100);
        app1.setSize(1200, 300);
        app1.setVisible(true);
        fm = pha.getFusedMatchedIons(q.getPeakList(), ph.getPeaksUsedFromIons1(), q.getMaxIntensity(), 0.1);
        SpectrumPanel sp2 = new SpectrumPanel(q.getMZArray(), q.getIntensityArray(), q.getPrecursorMZ(), q.getChargeString(), q.getTitle());
        sp2.setAnnotations(fm);
        JFrame app2 = new JFrame("Spectrum for " + q.getTitle() + " - " + ph.getModifiedSequence() + " (Fused)" + " - " + "Score: " + ph.getIonsScore());
        app2.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }
        });
        app2.getContentPane().add(sp2);
        app2.setLocation(110, 110);
        app2.setSize(1200, 300);
        app2.setVisible(true);
    }

    public static void drawSpectrum(PeptideHit aPeptideHit, MascotDatfile aMascotDatfile) {
        Query lQuery = (Query)aMascotDatfile.getPeptideToQueryMap().getQueriesByModifiedSequence(aPeptideHit.getModifiedSequence()).get(0);
        PeptideHitAnnotation lPeptideHitAnnotation = aPeptideHit.getPeptideHitAnnotation(aMascotDatfile.getMasses(), aMascotDatfile.getParametersSection(), lQuery.getPrecursorMZ(), lQuery.getChargeString());
        Vector lFusedFragmentionsVec = lPeptideHitAnnotation.getFusedMatchedIons(lQuery.getPeakList(), aPeptideHit.getPeaksUsedFromIons1(), lQuery.getMaxIntensity(), 0.1);
        SpectrumPanel sp1 = new SpectrumPanel(lQuery.getMZArray(), lQuery.getIntensityArray(), lQuery.getPrecursorMZ(), lQuery.getChargeString(), lQuery.getTitle());
        sp1.setAnnotations(lFusedFragmentionsVec);
        JFrame app1 = new JFrame("Spectrum for " + lQuery.getTitle() + " - " + aPeptideHit.getModifiedSequence() + " - " + "Score: " + aPeptideHit.getIonsScore());
        app1.setDefaultCloseOperation(3);
        app1.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        app1.getContentPane().add(sp1);
        app1.setLocation(100, 100);
        app1.setSize(1200, 300);
        app1.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPanel getAnnotatedSpectrumPanel(MascotDatfile aMdf, int aQueryNumber, int aPeptidehitNumber, double aIntensityPercentage) {
        JPanel jpan1 = new JPanel(new BorderLayout());
        PeptideHit lPeptideHit = aMdf.getQueryToPeptideMap().getPeptideHitOfOneQuery(aQueryNumber, aPeptidehitNumber);
        Query lQuery = (Query)aMdf.getQueryList().get(aQueryNumber - 1);
        if (lQuery == null) {
            try {
                try {
                    throw new IllegalArgumentException("The requested query does not extist!");
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    System.err.println("System.exit(1)");
                    System.exit(1);
                }
            }
            catch (Throwable throwable) {
                System.err.println("System.exit(1)");
                System.exit(1);
                throw throwable;
            }
        }
        PeptideHitAnnotation lPeptideHitAnnotation = lPeptideHit.getPeptideHitAnnotation(aMdf.getMasses(), aMdf.getParametersSection(), lQuery.getPrecursorMZ(), lQuery.getChargeString());
        Vector lFusedFragmentionsVec = lPeptideHitAnnotation.getFusedMatchedIons(lQuery.getPeakList(), lPeptideHit.getPeaksUsedFromIons1(), lQuery.getMaxIntensity(), aIntensityPercentage);
        JPanel jpanPeptideHit = new JPanel(new BorderLayout());
        jpanPeptideHit.add((Component)new JLabel("Modified Sequence: " + lPeptideHit.getModifiedSequence()), "East");
        jpanPeptideHit.add((Component)new JLabel("Score vs Threshold: " + lPeptideHit.getIonsScore() + " \\ " + lPeptideHit.calculateIdentityThreshold()), "West");
        SpectrumPanel sp1 = new SpectrumPanel(lQuery.getMZArray(), lQuery.getIntensityArray(), lQuery.getPrecursorMZ(), lQuery.getChargeString(), lQuery.getTitle());
        sp1.setAnnotations(lFusedFragmentionsVec);
        jpan1.add((Component)sp1, "Center");
        jpan1.add((Component)jpanPeptideHit, "South");
        jpan1.validate();
        return jpan1;
    }

    public static JPanel getAnnotatedSpectrumPanel(MascotDatfile aMdf, int aQueryNumber, int aPeptidehitNumber) {
        return DrawSpectrum.getAnnotatedSpectrumPanel(aMdf, aQueryNumber, aPeptidehitNumber, 0.1);
    }
}

