/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class CommandLineUtils {
    public static final String SEPARATOR = ",";

    public static String getCommandLineArgument(ArrayList<File> files) {
        String result = "";
        for (File file : files) {
            if (!result.equals("")) {
                result = result + SEPARATOR;
            }
            result = result + CommandLineUtils.getQuoteType() + file.getAbsolutePath() + CommandLineUtils.getQuoteType();
        }
        return result;
    }

    public static String concatenate(ArrayList<String> args) {
        if (args == null) {
            return null;
        }
        String quote = CommandLineUtils.getQuoteType();
        String result = "";
        for (String arg : args) {
            if (!result.equals("")) {
                result = result + " ";
            }
            if (!(arg.startsWith("-") || arg.startsWith("\"") || arg.startsWith("'"))) {
                arg = quote + arg + quote;
            }
            result = result + arg;
        }
        return result;
    }

    public static String concatenate(String[] args) {
        if (args == null) {
            return null;
        }
        String quote = CommandLineUtils.getQuoteType();
        String result = "";
        for (String arg : args) {
            if (!result.equals("")) {
                result = result + " ";
            }
            if (!(arg.startsWith("-") || arg.startsWith("\"") || arg.startsWith("'"))) {
                arg = quote + arg + quote;
            }
            result = result + arg;
        }
        return result;
    }

    public static String getQuoteType() {
        String quote = "";
        if (System.getProperty("os.name").lastIndexOf("Windows") != -1) {
            quote = "\"";
        }
        return quote;
    }

    public static String getCommandLineArgument(File file) {
        return CommandLineUtils.getQuoteType() + file.getAbsolutePath() + CommandLineUtils.getQuoteType();
    }

    public static ArrayList<String> splitInput(String cliInput) {
        ArrayList<String> results = new ArrayList<String>();
        if (cliInput == null || cliInput.trim().length() == 0) {
            return results;
        }
        for (String tempInput : cliInput.split(SEPARATOR)) {
            results.add(tempInput.trim());
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<File> getFiles(String optionInput, ArrayList<String> fileExtentions) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<String> files = CommandLineUtils.splitInput(optionInput);
        if (files.size() == 1) {
            File testFile = new File(files.get(0));
            if (!testFile.exists()) throw new FileNotFoundException(files.get(0) + " not found.");
            if (testFile.isDirectory()) {
                block0: for (File childFile : testFile.listFiles()) {
                    String fileName = Util.getFileName(childFile.getAbsolutePath());
                    for (String extention : fileExtentions) {
                        if (!fileName.toLowerCase().endsWith(extention)) continue;
                        if (!childFile.exists()) throw new FileNotFoundException(childFile.getAbsolutePath() + " not found.");
                        result.add(childFile);
                        continue block0;
                    }
                }
                return result;
            }
            String fileName = Util.getFileName(testFile.getAbsolutePath());
            for (String extention : fileExtentions) {
                if (!fileName.toLowerCase().endsWith(extention)) continue;
                result.add(testFile);
                return result;
            }
            return result;
        }
        block3: for (String file : files) {
            for (String extention : fileExtentions) {
                if (!file.toLowerCase().endsWith(extention)) continue;
                File testFile = new File(file);
                if (!testFile.exists()) throw new FileNotFoundException(file + " not found.");
                result.add(testFile);
                continue block3;
            }
        }
        return result;
    }

    public static ArrayList<Integer> getIntegerListFromString(String aString, String separator) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String component : aString.split(separator)) {
            try {
                Integer input = new Integer(component.trim());
                result.add(input);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot parse " + component.trim() + " into an integer from " + aString + " with separator '" + separator + "'.");
            }
        }
        return result;
    }

    public static ArrayList<Double> getDoubleListFromString(String aString, String separator) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (String component : aString.split(separator)) {
            result.add(new Double(component.trim()));
        }
        return result;
    }
}

