/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.tags;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import java.util.ArrayList;
import java.util.HashMap;

public class SequenceSegment {
    private int terminalIndex;
    private int length = 0;
    private HashMap<Integer, Character> mutations = null;
    private HashMap<Integer, String> modificationMatches = null;
    private SequenceSegment previousSegment = null;
    public final boolean nTerminus;
    private Integer mutationIndex = null;
    private Character mutation = null;
    private String modificationAtTerminus = null;
    private double mass = 0.0;

    public SequenceSegment(int terminalIndex, boolean nTerminus) {
        this.nTerminus = nTerminus;
        this.terminalIndex = terminalIndex;
    }

    public SequenceSegment(SequenceSegment sequenceSegment) {
        this.nTerminus = sequenceSegment.nTerminus;
        this.terminalIndex = sequenceSegment.getTerminalIndex();
        this.length = sequenceSegment.length();
        this.previousSegment = sequenceSegment;
        Integer otherMutationIndex = sequenceSegment.getMutationIndex();
        if (otherMutationIndex != null) {
            this.mutationIndex = otherMutationIndex;
            this.mutation = sequenceSegment.getMutation();
        }
        this.mass = sequenceSegment.getMass();
    }

    public int length() {
        return this.length;
    }

    public HashMap<Integer, Character> getMutations() {
        HashMap<Integer, Character> previousMutations;
        if (this.previousSegment != null && (previousMutations = this.previousSegment.getMutations()) != null) {
            if (this.mutations == null) {
                if (this.mutation == null) {
                    return previousMutations;
                }
                HashMap<Integer, Character> tempMutations = new HashMap<Integer, Character>(previousMutations.size());
                tempMutations.put(this.mutationIndex, this.mutation);
                return tempMutations;
            }
            this.mutations.putAll(previousMutations);
        }
        if (this.mutation != null) {
            if (this.mutations == null) {
                HashMap<Integer, Character> tempMutations = new HashMap<Integer, Character>(1);
                tempMutations.put(this.mutationIndex, this.mutation);
                return tempMutations;
            }
            this.mutations.put(this.mutationIndex, this.mutation);
        }
        return this.mutations;
    }

    public HashMap<Integer, String> getModificationMatches() {
        HashMap<Integer, String> previousModifications;
        if (this.previousSegment != null && (previousModifications = this.previousSegment.getModificationMatches()) != null) {
            if (this.modificationMatches == null) {
                if (this.modificationAtTerminus == null) {
                    return previousModifications;
                }
                HashMap<Integer, String> tempModifications = new HashMap<Integer, String>(previousModifications.size());
                tempModifications.put(this.length, this.modificationAtTerminus);
                return tempModifications;
            }
            this.modificationMatches.putAll(previousModifications);
        }
        if (this.modificationAtTerminus != null) {
            if (this.modificationMatches == null) {
                HashMap<Integer, String> tempModifications = new HashMap<Integer, String>(1);
                tempModifications.put(this.length, this.modificationAtTerminus);
                return tempModifications;
            }
            this.modificationMatches.put(this.length, this.modificationAtTerminus);
        }
        return this.modificationMatches;
    }

    public int getTerminalIndex() {
        return this.terminalIndex;
    }

    public int getIndexOnProtein() {
        if (this.nTerminus) {
            return this.terminalIndex + 1;
        }
        return this.terminalIndex - this.length;
    }

    public Integer getMutationIndex() {
        return this.mutationIndex;
    }

    public Character getMutation() {
        return this.mutation;
    }

    public double getMass() {
        return this.mass;
    }

    public void addMass(double mass) {
        this.mass += mass;
    }

    public void appendTerminus(SequenceSegment sequenceSegment) {
        HashMap<Integer, String> otherModifications;
        HashMap<Integer, Character> otherMutations = sequenceSegment.getMutations();
        if (otherMutations != null) {
            if (this.mutations == null) {
                this.mutations = new HashMap(otherMutations.size());
            }
            for (int index : otherMutations.keySet()) {
                this.mutations.put(index + this.length, otherMutations.get(index));
            }
        }
        if ((otherModifications = sequenceSegment.getModificationMatches()) != null) {
            if (this.modificationMatches == null) {
                this.modificationMatches = new HashMap(otherModifications.size());
            }
            for (int index : otherModifications.keySet()) {
                this.modificationMatches.put(index + this.length, otherModifications.get(index));
            }
        }
        this.length += sequenceSegment.length();
        this.terminalIndex = this.nTerminus ? (this.terminalIndex -= sequenceSegment.length()) : (this.terminalIndex += sequenceSegment.length());
        Integer otherMutationIndex = sequenceSegment.getMutationIndex();
        if (otherMutationIndex != null) {
            if (this.mutationIndex == null) {
                this.mutationIndex = otherMutationIndex;
                this.mutation = sequenceSegment.getMutation();
            } else if (this.mutations == null) {
                this.mutations = new HashMap();
                this.mutations.put(otherMutationIndex, this.mutation);
            }
        }
        this.mass += sequenceSegment.getMass();
    }

    public void appendTerminus(AminoAcidSequence aminoAcidSequence) {
        HashMap<Integer, ArrayList<ModificationMatch>> otherModifications = aminoAcidSequence.getModificationMatches();
        if (otherModifications != null) {
            if (this.modificationMatches == null) {
                this.modificationMatches = new HashMap(otherModifications.size());
            }
            for (int index : otherModifications.keySet()) {
                ArrayList<ModificationMatch> modificationMatchesList = otherModifications.get(index);
                if (this.modificationMatches.size() > 1) {
                    throw new IllegalArgumentException("Two PTMs found on the same amino acid when mapping tags. Only one supported.");
                }
                this.modificationMatches.put(index + this.length, modificationMatchesList.get(0).getTheoreticPtm());
            }
        }
        this.length += aminoAcidSequence.length();
        this.terminalIndex = this.nTerminus ? (this.terminalIndex -= aminoAcidSequence.length()) : (this.terminalIndex += aminoAcidSequence.length());
        this.mass += aminoAcidSequence.getMass().doubleValue();
    }

    public void appendTerminus(AminoAcidPattern aminoAcidPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> otherModifications = aminoAcidPattern.getModificationMatches();
        if (otherModifications != null) {
            if (this.modificationMatches == null) {
                this.modificationMatches = new HashMap(otherModifications.size());
            }
            for (int index : otherModifications.keySet()) {
                ArrayList<ModificationMatch> modificationMatchesList = otherModifications.get(index);
                if (this.modificationMatches.size() > 1) {
                    throw new IllegalArgumentException("Two PTMs found on the same amino acid when mapping tags. Only one supported.");
                }
                this.modificationMatches.put(index + this.length, modificationMatchesList.get(0).getTheoreticPtm());
            }
        }
        this.length += aminoAcidPattern.length();
        this.terminalIndex = this.nTerminus ? (this.terminalIndex -= aminoAcidPattern.length()) : (this.terminalIndex += aminoAcidPattern.length());
        this.mass += aminoAcidPattern.getMass().doubleValue();
    }

    public void appendTerminus(AminoAcid aminoAcid) {
        this.terminalIndex = this.nTerminus ? --this.terminalIndex : ++this.terminalIndex;
        ++this.length;
        this.mass += aminoAcid.monoisotopicMass;
    }

    public void addModificationTerminus(String modification) {
        PTM ptm = PTMFactory.getInstance().getPTM(modification);
        this.addModificationTerminus(modification, ptm.getMass());
    }

    public void addModificationTerminus(String modification, double modificationMass) {
        this.modificationAtTerminus = modification;
        this.mass += modificationMass;
    }

    public void addMutation(Integer index, Character aa) {
        if (this.mutationIndex == null) {
            this.mutationIndex = index;
            this.mutation = aa;
        } else {
            if (this.mutations == null) {
                this.mutations = new HashMap(1);
            }
            this.mutations.put(index, aa);
        }
    }

    public int getnMutations() {
        if (this.mutations == null) {
            if (this.mutationIndex == null) {
                return 0;
            }
            return 1;
        }
        return this.mutations.size();
    }

    public String getSegmentSequence(String sequence) {
        if (this.nTerminus) {
            return sequence.substring(this.terminalIndex + 1, this.terminalIndex + 1 + this.length);
        }
        return sequence.substring(this.terminalIndex - this.length, this.terminalIndex);
    }
}

