/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class AndromedaIdfileReader
extends ExperimentObject
implements IdfileReader {
    private HashMap<String, Long> index;
    private BufferedRandomAccessFile bufferedRandomAccessFile = null;
    private String fileName;
    private HashMap<String, LinkedList<Peptide>> peptideMap;
    private int peptideMapKeyLength;

    public AndromedaIdfileReader() {
    }

    public AndromedaIdfileReader(File resultsFile) throws FileNotFoundException, IOException {
        this(resultsFile, null);
    }

    public AndromedaIdfileReader(File resultsFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        this.bufferedRandomAccessFile = new BufferedRandomAccessFile(resultsFile, "r", 102400);
        this.fileName = Util.getFileName(resultsFile);
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = this.bufferedRandomAccessFile.length() / 100L;
        this.index = new HashMap();
        String title = null;
        boolean newTitle = false;
        while ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            if (line.startsWith(">")) {
                title = line.substring(1);
                newTitle = true;
                continue;
            }
            if (!newTitle) continue;
            long currentIndex = this.bufferedRandomAccessFile.getFilePointer();
            this.index.put(title, currentIndex);
            newTitle = false;
            if (waitingHandler == null) continue;
            waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
        }
    }

    @Override
    public String getExtension() {
        return ".res";
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, false);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        if (this.bufferedRandomAccessFile == null) {
            throw new IllegalStateException("The identification file was not set. Please use the appropriate constructor.");
        }
        if (sequenceMatchingPreferences != null) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            this.peptideMapKeyLength = sequenceFactory.getDefaultProteinTree().getInitialTagSize();
            this.peptideMap = new HashMap(1024);
        }
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        for (String title : this.index.keySet()) {
            String line;
            SpectrumMatch currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(this.fileName, title));
            int cpt = 1;
            while ((line = this.bufferedRandomAccessFile.getNextLine()) != null && !line.startsWith(">")) {
                PeptideAssumption peptideAssumption = this.getAssumptionFromLine(line, cpt, sequenceMatchingPreferences);
                if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                    Peptide peptide = peptideAssumption.getPeptide();
                    ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        Peptide newPeptide = new Peptide(expandedSequence.toString(), new ArrayList<ModificationMatch>(modificationMatches.size()));
                        for (ModificationMatch modificationMatch : modificationMatches) {
                            newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                        }
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                        currentMatch.addHit(Advocate.andromeda.getIndex(), newAssumption, true);
                    }
                } else {
                    currentMatch.addHit(Advocate.andromeda.getIndex(), peptideAssumption, true);
                }
                ++cpt;
            }
            result.add(currentMatch);
        }
        return result;
    }

    private PeptideAssumption getAssumptionFromLine(String line, int rank, SequenceMatchingPreferences sequenceMatchingPreferences) {
        String[] temp = line.trim().split("\t");
        String[] temp1 = temp[4].split(",");
        ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
        for (int aa = 0; aa < temp1.length; ++aa) {
            String mod = temp1[aa];
            if (mod.equals("A")) continue;
            modMatches.add(new ModificationMatch(mod, true, aa));
        }
        String sequence = temp[0];
        Peptide peptide = new Peptide(sequence, modMatches);
        if (sequenceMatchingPreferences != null) {
            String subSequence = sequence.substring(0, this.peptideMapKeyLength);
            LinkedList<Peptide> peptidesForTag = this.peptideMap.get(subSequence = AminoAcid.getMatchingSequence(subSequence, sequenceMatchingPreferences));
            if (peptidesForTag == null) {
                peptidesForTag = new LinkedList();
                this.peptideMap.put(subSequence, peptidesForTag);
            }
            peptidesForTag.add(peptide);
        }
        Charge charge = new Charge(1, new Integer(temp[6]));
        double score = new Double(temp[1]);
        return new PeptideAssumption(peptide, rank, Advocate.andromeda.getIndex(), charge, score, this.fileName);
    }

    @Override
    public void close() throws IOException {
        this.bufferedRandomAccessFile.close();
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("1.4.0.0");
        result.put("Andromeda", versions);
        return result;
    }

    @Override
    public HashMap<String, LinkedList<Peptide>> getPeptidesMap() {
        return this.peptideMap;
    }

    @Override
    public HashMap<String, LinkedList<SpectrumMatch>> getTagsMap() {
        return new HashMap<String, LinkedList<SpectrumMatch>>();
    }

    @Override
    public void clearTagsMap() {
    }

    @Override
    public void clearPeptidesMap() {
        if (this.peptideMap != null) {
            this.peptideMap.clear();
        }
    }
}

