/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.AbstractCompoundSet;

public abstract class AbstractNucleotideCompoundSet<C extends NucleotideCompound>
extends AbstractCompoundSet<C> {
    protected void addNucleotideCompound(String base, String complement, String ... equivalents) {
        String[] upperEquivalents = new String[equivalents.length];
        String[] lowerEquivalents = new String[equivalents.length];
        for (int i = 0; i < equivalents.length; ++i) {
            upperEquivalents[i] = equivalents[i].toUpperCase();
            lowerEquivalents[i] = equivalents[i].toLowerCase();
        }
        C upper = this.newNucleotideCompound(base.toUpperCase(), complement.toUpperCase(), upperEquivalents);
        C lower = this.newNucleotideCompound(base.toLowerCase(), complement.toLowerCase(), lowerEquivalents);
        ArrayList equivalentCompounds = new ArrayList();
        for (int i = 0; i < equivalents.length; ++i) {
            equivalentCompounds.add(this.getCompoundForString(upperEquivalents[i]));
            equivalentCompounds.add(this.getCompoundForString(lowerEquivalents[i]));
        }
        this.addCompound(upper, lower, equivalentCompounds);
    }

    protected abstract C newNucleotideCompound(String var1, String var2, String ... var3);

    protected void calculateIndirectAmbiguities() {
        HashMap<NucleotideCompound, List<NucleotideCompound>> equivalentsMap = new HashMap<NucleotideCompound, List<NucleotideCompound>>();
        ArrayList<NucleotideCompound> ambiguousCompounds = new ArrayList<NucleotideCompound>();
        for (NucleotideCompound compound : this.getAllCompounds()) {
            if (!compound.isAmbiguous()) continue;
            ambiguousCompounds.add(compound);
        }
        for (NucleotideCompound sourceCompound : ambiguousCompounds) {
            Set<NucleotideCompound> compoundConstituents = sourceCompound.getConstituents();
            for (NucleotideCompound targetCompound : ambiguousCompounds) {
                Set<NucleotideCompound> targetConstituents = targetCompound.getConstituents();
                if (!targetConstituents.containsAll(compoundConstituents)) continue;
                NucleotideCompound lcSourceCompound = this.toLowerCase(sourceCompound);
                NucleotideCompound lcTargetCompound = this.toLowerCase(targetCompound);
                this.checkAdd(equivalentsMap, sourceCompound, targetCompound);
                this.checkAdd(equivalentsMap, sourceCompound, lcTargetCompound);
                this.checkAdd(equivalentsMap, targetCompound, sourceCompound);
                this.checkAdd(equivalentsMap, lcTargetCompound, sourceCompound);
                this.checkAdd(equivalentsMap, lcSourceCompound, targetCompound);
                this.checkAdd(equivalentsMap, lcSourceCompound, lcTargetCompound);
            }
        }
        for (NucleotideCompound key : equivalentsMap.keySet()) {
            List vals = (List)equivalentsMap.get(key);
            for (NucleotideCompound value : vals) {
                this.addEquivalent(key, value);
                this.addEquivalent(value, key);
            }
        }
    }

    private void checkAdd(Map<NucleotideCompound, List<NucleotideCompound>> equivalentsMap, NucleotideCompound key, NucleotideCompound value) {
        List<NucleotideCompound> listS = equivalentsMap.get(key);
        if (listS == null) {
            listS = new ArrayList<NucleotideCompound>();
            equivalentsMap.put(key, listS);
        }
        listS.add(value);
    }

    private NucleotideCompound toLowerCase(NucleotideCompound compound) {
        return (NucleotideCompound)this.getCompoundForString(compound.getBase().toLowerCase());
    }

    public NucleotideCompound getAmbiguity(NucleotideCompound ... compounds) {
        HashSet settedCompounds = new HashSet();
        for (NucleotideCompound compound : compounds) {
            for (NucleotideCompound subCompound : compound.getConstituents()) {
                settedCompounds.add(this.getCompoundForString(subCompound.getBase().toUpperCase()));
            }
        }
        for (NucleotideCompound compound : this.getAllCompounds()) {
            if (!compound.getConstituents().equals(settedCompounds)) continue;
            return compound;
        }
        return null;
    }

    @Override
    public boolean isComplementable() {
        return true;
    }
}

