### R code from vignette source 'RMassBankNonstandard.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: RMassBankNonstandard.Rnw:24-26
###################################################
options(width=74)
#library(xtable)


###################################################
### code chunk number 2: RMassBankNonstandard.Rnw:41-44
###################################################
library("RMassBank")
library("RMassBankData")
library("gplots")


###################################################
### code chunk number 3: RMassBankNonstandard.Rnw:50-51 (eval = FALSE)
###################################################
## vignette("RMassBank")


###################################################
### code chunk number 4: RMassBankNonstandard.Rnw:71-78
###################################################
RmbDefaultSettings()
rmbo <- getOption("RMassBank")
rmbo$recalibrator <- list(
		"MS1" = "recalibrate.identity",
		"MS2" = "recalibrate.identity"
	)
options("RMassBank" = rmbo)


###################################################
### code chunk number 5: RMassBankNonstandard.Rnw:84-86
###################################################
w <- loadMsmsWorkspace(system.file("results/pH_narcotics_RF.RData", 
				package="RMassBankData"))


###################################################
### code chunk number 6: RMassBankNonstandard.Rnw:90-99
###################################################
recal <- makeRecalibration(w@parent, "pH",
				recalibrateBy = rmbo$recalibrateBy,
				recalibrateMS1 = rmbo$recalibrateMS1,
				recalibrator = list(MS1="recalibrate.loess",MS2="recalibrate.loess"),
				recalibrateMS1Window = 15)
w@rc <- recal$rc
w@rc.ms1 <- recal$rc.ms1
w@parent <- w
plotRecalibration(w)


###################################################
### code chunk number 7: RMassBankNonstandard.Rnw:103-105
###################################################
w@spectra[[1]]@parent@mz[30:32]
w@spectra[[1]]@children[[1]]@mz[15:17]


###################################################
### code chunk number 8: RMassBankNonstandard.Rnw:111-112
###################################################
w <- msmsWorkflow(w, steps=4)


###################################################
### code chunk number 9: RMassBankNonstandard.Rnw:118-120
###################################################
w@spectra[[1]]@parent@mz[30:32]
w@spectra[[1]]@children[[1]]@mz[15:17]


###################################################
### code chunk number 10: RMassBankNonstandard.Rnw:138-158
###################################################
RmbDefaultSettings()
getOption("RMassBank")$multiplicityFilter

# to make processing faster, we only use 3 spectra per compound
rmbo <- getOption("RMassBank")
rmbo$spectraList <- list(
    list(mode="CID", ces = "35%", ce = "35 % (nominal)", res = 7500),
    list(mode="HCD", ces = "15%", ce = "15 % (nominal)", res = 7500),
    list(mode="HCD", ces = "30%", ce = "30 % (nominal)", res = 7500)
)
options(RMassBank = rmbo)

loadList(system.file("list/NarcoticsDataset.csv", 
        package="RMassBankData"))


w <- newMsmsWorkspace()
files <- list.files(system.file("spectra", package="RMassBankData"),
        ".mzML", full.names = TRUE)
w@files <- files[1:2]


###################################################
### code chunk number 11: RMassBankNonstandard.Rnw:161-169
###################################################
w1 <- msmsWorkflow(w, mode="pH", steps=c(1))
# Here we artificially cut spectra out to make the workflow run faster for the vignette:
w1@spectra <- as(lapply(w1@spectra, function(s)
    {
		s@children <- s@children[1:3]
		s
    }),"SimpleList")
w1 <- msmsWorkflow(w1, mode="pH", steps=c(2:7))


###################################################
### code chunk number 12: RMassBankNonstandard.Rnw:175-184
###################################################
w2 <- msmsWorkflow(w, mode="pH", steps=c(1), confirmMode = 1)
# Here we artificially cut spectra out to make the workflow run faster for the vignette:

w2@spectra <- as(lapply(w2@spectra, function(s)
    {
		s@children <- s@children[1:3]
		s
    }),"SimpleList")
w2 <- msmsWorkflow(w2, mode="pH", steps=c(2:7))


###################################################
### code chunk number 13: RMassBankNonstandard.Rnw:190-192
###################################################
wTotal <- combineMultiplicities(c(w1, w2))
wTotal <- msmsWorkflow(wTotal, steps=8, mode="pH", archivename = "output")


###################################################
### code chunk number 14: RMassBankNonstandard.Rnw:197-199
###################################################
mb <- newMbWorkspace(wTotal)
# [...] load lists, execute workflow etc.


###################################################
### code chunk number 15: RMassBankNonstandard.Rnw:206-207
###################################################
sessionInfo()


