/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class FixBAMFile {
    public static void main(String[] args) {
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        SAMFileReader reader = new SAMFileReader(inputFile);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMFileHeader header = reader.getFileHeader();
        SAMFileWriter writer = new SAMFileWriterFactory().makeBAMWriter(header, true, outputFile);
        for (SAMRecord record : reader) {
            if (record.getIndexingBin() != null) {
                record.setIndexingBin(record.computeIndexingBin());
            }
            writer.addAlignment(record);
        }
        writer.close();
    }
}

