/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseControl;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxPerimeter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class mxConnectionHandler
extends mxMouseControl {
    private static final long serialVersionUID = -2543899557644889853L;
    public static Cursor DEFAULT_CURSOR = new Cursor(12);
    protected mxGraphComponent graphComponent;
    protected ImageIcon connectIcon = null;
    protected int handleSize = mxConstants.CONNECT_HANDLE_SIZE;
    protected boolean handleEnabled = mxConstants.CONNECT_HANDLE_ENABLED;
    protected boolean select = true;
    protected boolean createTarget = false;
    protected boolean keepOnTop = true;
    protected transient Point start;
    protected transient Point current;
    protected transient mxCellState source;
    protected transient mxCellMarker marker;
    protected transient String error;
    protected transient JPanel preview = new JPanel(){
        private static final long serialVersionUID = -6401041861368362818L;

        public void paint(Graphics graphics) {
            super.paint(graphics);
            ((Graphics2D)graphics).setStroke(mxConstants.PREVIEW_STROKE);
            if (mxConnectionHandler.this.start != null && mxConnectionHandler.this.current != null) {
                if (mxConnectionHandler.this.marker.hasValidState() || mxConnectionHandler.this.createTarget || mxConnectionHandler.this.graphComponent.getGraph().isAllowDanglingEdges()) {
                    graphics.setColor(mxConstants.DEFAULT_VALID_COLOR);
                } else {
                    graphics.setColor(mxConstants.DEFAULT_INVALID_COLOR);
                }
                graphics.drawLine(mxConnectionHandler.this.start.x - this.getX(), mxConnectionHandler.this.start.y - this.getY(), mxConnectionHandler.this.current.x - this.getX(), mxConnectionHandler.this.current.y - this.getY());
            }
        }
    };
    protected transient mxEventSource.mxIEventListener resetHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxConnectionHandler.this.reset();
        }
    };

    public mxConnectionHandler(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent.mxGraphControl mxGraphControl2 = mxGraphComponent2.getGraphControl();
        mxGraphControl2.add((Component)this, 0);
        mxGraphControl2.addMouseListener(this);
        mxGraphControl2.addMouseMotionListener(this);
        mxGraphView mxGraphView2 = mxGraphComponent2.getGraph().getView();
        mxGraphView2.addListener("scale", this.resetHandler);
        mxGraphView2.addListener("translate", this.resetHandler);
        mxGraphView2.addListener("scaleAndTranslate", this.resetHandler);
        mxIGraphModel mxIGraphModel2 = mxGraphComponent2.getGraph().getModel();
        mxIGraphModel2.addListener("change", this.resetHandler);
        this.marker = new mxCellMarker(mxGraphComponent2){
            private static final long serialVersionUID = 103433247310526381L;

            protected Object getCell(MouseEvent mouseEvent) {
                Object object = super.getCell(mouseEvent);
                if (mxConnectionHandler.this.isConnecting()) {
                    if (mxConnectionHandler.this.source != null) {
                        mxConnectionHandler.this.error = mxConnectionHandler.this.validateConnection(mxConnectionHandler.this.source.getCell(), object);
                        if (mxConnectionHandler.this.error != null && mxConnectionHandler.this.error.length() == 0) {
                            object = null;
                            if (mxConnectionHandler.this.createTarget) {
                                mxConnectionHandler.this.error = null;
                            }
                        }
                    }
                } else if (!mxConnectionHandler.this.isValidSource(object)) {
                    object = null;
                }
                return object;
            }

            protected boolean isValidState(mxCellState mxCellState2) {
                if (mxConnectionHandler.this.isConnecting()) {
                    return mxConnectionHandler.this.error == null;
                }
                return super.isValidState(mxCellState2);
            }

            protected Color getMarkerColor(MouseEvent mouseEvent, mxCellState mxCellState2, boolean bl) {
                return mxConnectionHandler.this.isHighlighting() || mxConnectionHandler.this.isConnecting() ? super.getMarkerColor(mouseEvent, mxCellState2, bl) : null;
            }

            protected boolean intersects(mxCellState mxCellState2, MouseEvent mouseEvent) {
                if (!mxConnectionHandler.this.isHighlighting() || mxConnectionHandler.this.isConnecting()) {
                    return true;
                }
                return super.intersects(mxCellState2, mouseEvent);
            }
        };
        this.marker.setHotspotEnabled(true);
        this.setCursor(DEFAULT_CURSOR);
    }

    public boolean isConnecting() {
        return this.start != null && this.preview != null && this.preview.isVisible();
    }

    public boolean isHighlighting() {
        return this.connectIcon == null && !this.handleEnabled;
    }

    public boolean isKeepOnTop() {
        return this.keepOnTop;
    }

    public void setKeepOnTop(boolean bl) {
        this.keepOnTop = bl;
    }

    public void setConnectIcon(ImageIcon imageIcon) {
        this.connectIcon = imageIcon;
    }

    public ImageIcon getConnecIcon() {
        return this.connectIcon;
    }

    public void setHandleEnabled(boolean bl) {
        this.handleEnabled = bl;
    }

    public boolean isHandleEnabled() {
        return this.handleEnabled;
    }

    public void setHandleSize(int n) {
        this.handleSize = n;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public mxCellMarker getMarker() {
        return this.marker;
    }

    public void setMarker(mxCellMarker mxCellMarker2) {
        this.marker = mxCellMarker2;
    }

    public void setCreateTarget(boolean bl) {
        this.createTarget = bl;
    }

    public boolean isCreateTarget() {
        return this.createTarget;
    }

    public void setSelect(boolean bl) {
        this.select = bl;
    }

    public boolean isSelect() {
        return this.select;
    }

    public void reset() {
        if (this.preview.getParent() != null) {
            this.preview.setVisible(false);
            this.preview.getParent().remove(this.preview);
        }
        this.setVisible(false);
        this.marker.reset();
        this.source = null;
        this.start = null;
        this.error = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(Object object, Object object2, MouseEvent mouseEvent) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        Object object3 = null;
        Object object4 = null;
        if (object2 == null && this.createTarget) {
            object2 = object3 = this.createTargetVertex(mouseEvent, object);
        }
        if (object2 != null || mxGraph2.isAllowDanglingEdges()) {
            mxIGraphModel2.beginUpdate();
            try {
                mxPoint mxPoint2;
                mxGeometry mxGeometry2;
                Object object5;
                Object object6 = mxGraph2.getDropTarget(new Object[]{object3}, mouseEvent.getPoint(), this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY()));
                if (object3 != null) {
                    if (object6 == null || !mxGraph2.getModel().isEdge(object6)) {
                        object5 = mxGraph2.getView().getState(object6);
                        if (object5 != null) {
                            mxGeometry2 = mxIGraphModel2.getGeometry(object3);
                            mxPoint2 = ((mxCellState)object5).getOrigin();
                            mxGeometry2.setX(mxGeometry2.getX() - mxPoint2.getX());
                            mxGeometry2.setY(mxGeometry2.getY() - mxPoint2.getY());
                        }
                    } else {
                        object6 = mxGraph2.getDefaultParent();
                    }
                    mxGraph2.addCells(new Object[]{object3}, object6);
                }
                object5 = mxGraph2.getDefaultParent();
                if (mxIGraphModel2.getParent(object) == mxIGraphModel2.getParent(object2)) {
                    object5 = mxIGraphModel2.getParent(object);
                }
                if ((object4 = this.insertEdge(object5, null, "", object, object2)) != null) {
                    mxGeometry2 = mxIGraphModel2.getGeometry(object4);
                    if (mxGeometry2 == null) {
                        mxGeometry2 = new mxGeometry();
                        mxGeometry2.setRelative(true);
                        mxIGraphModel2.setGeometry(object4, mxGeometry2);
                    }
                    if (object2 == null) {
                        mxPoint2 = this.graphComponent.getPointForEvent(mouseEvent);
                        mxGeometry2.setTerminalPoint(mxPoint2, false);
                    }
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
        if (this.select) {
            mxGraph2.setSelectionCell(object4);
        }
    }

    protected Object insertEdge(Object object, String string, Object object2, Object object3, Object object4) {
        return this.graphComponent.getGraph().insertEdge(object, string, object2, object3, object4);
    }

    public Object createTargetVertex(MouseEvent mouseEvent, Object object) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        Object object2 = mxGraph2.cloneCells(new Object[]{object})[0];
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object2);
        if (mxGeometry2 != null) {
            mxPoint mxPoint2 = this.graphComponent.getPointForEvent(mouseEvent);
            mxGeometry2.setX(mxGraph2.snap(mxPoint2.getX() - mxGeometry2.getWidth() / 2.0));
            mxGeometry2.setY(mxGraph2.snap(mxPoint2.getY() - mxGeometry2.getHeight() / 2.0));
        }
        return object2;
    }

    public boolean isValidSource(Object object) {
        return this.graphComponent.getGraph().isValidSource(object);
    }

    public boolean isValidTarget(Object object) {
        return true;
    }

    public String validateConnection(Object object, Object object2) {
        if (object2 == null && this.createTarget) {
            return null;
        }
        if (!this.isValidTarget(object2)) {
            return "";
        }
        return this.graphComponent.getGraph().getEdgeValidationError(null, object, object2);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.graphComponent.isForceMarqueeEvent(mouseEvent) && !this.graphComponent.isPanningEvent(mouseEvent) && !mouseEvent.isConsumed() && this.source != null && !mouseEvent.isPopupTrigger() && (this.isHighlighting() && this.marker.hasValidState() || !this.isHighlighting() && this.getBounds().contains(mouseEvent.getPoint()))) {
            this.start = mouseEvent.getPoint();
            this.preview.setOpaque(false);
            this.preview.setVisible(false);
            this.graphComponent.getGraphControl().add((Component)this.preview, 0);
            this.getParent().setComponentZOrder(this, 0);
            this.graphComponent.getGraphControl().setCursor(DEFAULT_CURSOR);
            this.marker.reset();
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.source != null && this.start != null) {
            Cloneable cloneable;
            mxPerimeter.mxPerimeterFunction mxPerimeterFunction2;
            int n = mouseEvent.getX() - this.start.x;
            int n2 = mouseEvent.getY() - this.start.y;
            if (!this.preview.isVisible() && this.graphComponent.isSignificant(n, n2)) {
                this.preview.setVisible(true);
                this.marker.reset();
            }
            this.current = mouseEvent.getPoint();
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            mxGraphView mxGraphView2 = mxGraph2.getView();
            double d = mxGraphView2.getScale();
            mxPoint mxPoint2 = mxGraphView2.getTranslate();
            this.current.x = (int)Math.round((mxGraph2.snap((double)this.current.x / d - mxPoint2.getX()) + mxPoint2.getX()) * d);
            this.current.y = (int)Math.round((mxGraph2.snap((double)this.current.y / d - mxPoint2.getY()) + mxPoint2.getY()) * d);
            this.marker.process(mouseEvent);
            mxCellState mxCellState2 = this.marker.getValidState();
            if (mxCellState2 != null) {
                this.current.x = (int)mxCellState2.getCenterX();
                this.current.y = (int)mxCellState2.getCenterY();
                mxPerimeterFunction2 = mxGraphView2.getPerimeterFunction(mxCellState2);
                if (mxPerimeterFunction2 != null) {
                    cloneable = new mxPoint(this.source.getCenterX(), this.source.getCenterY());
                    mxPoint mxPoint3 = mxPerimeterFunction2.apply(mxGraphView2.getPerimeterBounds(mxCellState2, null, false), null, mxCellState2, false, (mxPoint)cloneable);
                    if (mxPoint3 != null) {
                        this.current = mxPoint3.getPoint();
                    }
                }
            }
            if ((mxPerimeterFunction2 = mxGraphView2.getPerimeterFunction(this.source)) != null) {
                cloneable = mxPerimeterFunction2.apply(mxGraphView2.getPerimeterBounds(this.source, null, true), null, this.source, true, new mxPoint(this.current));
                if (cloneable != null) {
                    this.start = ((mxPoint)cloneable).getPoint();
                }
            } else {
                this.start = new Point((int)Math.round(this.source.getCenterX()), (int)Math.round(this.source.getCenterY()));
            }
            this.setVisible(false);
            cloneable = new Rectangle(this.current);
            ((Rectangle)cloneable).add(this.start);
            ((Rectangle)cloneable).grow(1, 1);
            this.preview.setBounds((Rectangle)cloneable);
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.isConnecting()) {
            if (this.error != null) {
                if (this.error.length() > 0) {
                    JOptionPane.showMessageDialog(this.graphComponent, this.error);
                }
            } else if (this.source != null) {
                Object object = this.source.getCell();
                Object object2 = this.marker.hasValidState() ? this.marker.getValidState().getCell() : null;
                this.connect(object, object2, mouseEvent);
            }
            mouseEvent.consume();
        } else if (this.source != null && !mouseEvent.isPopupTrigger()) {
            this.graphComponent.selectCellForEvent(this.source.getCell(), mouseEvent);
        }
        this.reset();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.graphComponent.isEnabled() && this.isEnabled()) {
            this.source = this.marker.process(mouseEvent);
            if (this.isHighlighting() && !this.marker.hasValidState()) {
                this.source = null;
            }
            if (this.source != null) {
                if (this.isHighlighting()) {
                    this.setBounds(this.source.getRectangle());
                } else {
                    int n = this.handleSize;
                    int n2 = this.handleSize;
                    if (this.connectIcon != null) {
                        n = this.connectIcon.getIconWidth();
                        n2 = this.connectIcon.getIconHeight();
                    }
                    int n3 = (int)this.source.getCenterX() - n / 2;
                    int n4 = (int)this.source.getCenterY() - n2 / 2;
                    if (this.graphComponent.getGraph().isSwimlane(this.source.getCell())) {
                        mxRectangle mxRectangle2 = this.graphComponent.getGraph().getStartSize(this.source.getCell());
                        if (mxRectangle2.getWidth() > 0.0) {
                            n3 = (int)(this.source.getX() + mxRectangle2.getWidth() / 2.0 - (double)(n / 2));
                        } else {
                            n4 = (int)(this.source.getY() + mxRectangle2.getHeight() / 2.0 - (double)(n2 / 2));
                        }
                    }
                    this.setBounds(n3, n4, n, n2);
                }
                if (this.keepOnTop) {
                    this.getParent().setComponentZOrder(this, 0);
                }
            }
            this.setVisible(this.source != null);
        }
    }

    public void paint(Graphics graphics) {
        if (this.start == null) {
            if (this.connectIcon != null) {
                graphics.drawImage(this.connectIcon.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            } else if (this.handleEnabled) {
                graphics.setColor(Color.BLACK);
                graphics.draw3DRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, true);
                graphics.setColor(Color.GREEN);
                graphics.fill3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, true);
                graphics.setColor(Color.BLUE);
                graphics.drawRect(this.getWidth() / 2 - 1, this.getHeight() / 2 - 1, 1, 1);
            }
        }
    }
}

