/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pair<T>
implements Collection<T>,
Serializable {
    private T first;
    private T second;

    public Pair(T value1, T value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException("Pair cannot contain null values");
        }
        this.first = value1;
        this.second = value2;
    }

    public Pair(Collection<? extends T> values) {
        if (values == null) {
            throw new IllegalArgumentException("Input collection cannot be null");
        }
        if (values.size() == 2) {
            if (values.contains(null)) {
                throw new IllegalArgumentException("Pair cannot contain null values");
            }
        } else {
            throw new IllegalArgumentException("Pair may only be created from a Collection of exactly 2 elements");
        }
        Iterator<T> iter = values.iterator();
        this.first = iter.next();
        this.second = iter.next();
    }

    public Pair(T[] values) {
        if (values == null) {
            throw new IllegalArgumentException("Input array cannot be null");
        }
        if (values.length == 2) {
            if (values[0] == null || values[1] == null) {
                throw new IllegalArgumentException("Pair cannot contain null values");
            }
        } else {
            throw new IllegalArgumentException("Pair may only be created from an array of 2 elements");
        }
        this.first = values[0];
        this.second = values[1];
    }

    public T getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Pair) {
            Pair otherPair = (Pair)o;
            T otherFirst = otherPair.getFirst();
            T otherSecond = otherPair.getSecond();
            return (this.first == otherFirst || this.first != null && this.first.equals(otherFirst)) && (this.second == otherSecond || this.second != null && this.second.equals(otherSecond));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.first == null ? 0 : this.first.hashCode());
        hashCode = 31 * hashCode + (this.second == null ? 0 : this.second.hashCode());
        return hashCode;
    }

    public String toString() {
        return "<" + this.first.toString() + ", " + this.second.toString() + ">";
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException("Pairs cannot be mutated");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Pairs cannot be mutated");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Pairs cannot be mutated");
    }

    @Override
    public boolean contains(Object o) {
        return this.first == o || this.first.equals(o) || this.second == o || this.second.equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() > 2) {
            return false;
        }
        Iterator<?> iter = c.iterator();
        Object c_first = iter.next();
        Object c_second = iter.next();
        return this.contains(c_first) && this.contains(c_second);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new PairIterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Pairs cannot be mutated");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Pairs cannot be mutated");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Pairs cannot be mutated");
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public Object[] toArray() {
        Object[] to_return = new Object[]{this.first, this.second};
        return to_return;
    }

    @Override
    public <S> S[] toArray(S[] a) {
        Object[] to_return = a;
        Class<?> type = a.getClass().getComponentType();
        if (a.length < 2) {
            to_return = (Object[])Array.newInstance(type, 2);
        }
        to_return[0] = this.first;
        to_return[1] = this.second;
        if (to_return.length > 2) {
            to_return[2] = null;
        }
        return to_return;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PairIterator
    implements Iterator<T> {
        int position = 0;

        private PairIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < 2;
        }

        @Override
        public T next() {
            ++this.position;
            if (this.position == 1) {
                return Pair.this.first;
            }
            if (this.position == 2) {
                return Pair.this.second;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Pairs cannot be mutated");
        }
    }
}

