/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.layout.util.VisRunner;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTransition<V, E>
implements IterativeContext {
    protected Layout<V, E> startLayout;
    protected Layout<V, E> endLayout;
    protected Layout<V, E> transitionLayout;
    protected boolean done = false;
    protected int count = 20;
    protected int counter = 0;
    protected VisualizationViewer<V, E> vv;

    public LayoutTransition(VisualizationViewer<V, E> vv, Layout<V, E> startLayout, Layout<V, E> endLayout) {
        this.vv = vv;
        this.startLayout = startLayout;
        this.endLayout = endLayout;
        if (endLayout instanceof IterativeContext) {
            VisRunner relaxer = new VisRunner((IterativeContext)((Object)endLayout));
            relaxer.prerelax();
        }
        this.transitionLayout = new StaticLayout<V, E>(startLayout.getGraph(), startLayout);
        vv.setGraphLayout(this.transitionLayout);
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public void step() {
        Graph<V, E> g = this.transitionLayout.getGraph();
        for (Object v : g.getVertices()) {
            Point2D tp = (Point2D)this.transitionLayout.transform(v);
            Point2D fp = (Point2D)this.endLayout.transform(v);
            double dx = (fp.getX() - tp.getX()) / (double)(this.count - this.counter);
            double dy = (fp.getY() - tp.getY()) / (double)(this.count - this.counter);
            this.transitionLayout.setLocation(v, new Point2D.Double(tp.getX() + dx, tp.getY() + dy));
        }
        ++this.counter;
        if (this.counter >= this.count) {
            this.done = true;
            this.vv.setGraphLayout(this.endLayout);
        }
        this.vv.repaint();
    }
}

