# Rsamtools

# order of -llib important -- bcf, bam before ws2_32

SAMTOOLS_PATH=\
    $(shell echo 'cat(Rsamtools:::.pkgLd())'|\
        "${R_HOME}/bin/R" --vanilla --slave)
SAMTOOLS_LIBS+="$(SAMTOOLS_PATH)/libbam.a" "$(SAMTOOLS_PATH)/libbam.a"\
    "$(SAMTOOLS_PATH)/libbcf.a" "$(SAMTOOLS_PATH)/libtabix.a"\
    -lws2_32 -pthread
SAMTOOLS_CPPFLAGS+=-D_USE_KNETFILE -DBGZF_CACHE -D_FILE_OFFSET_BITS=64 \
    -D_LARGEFILE64_SOURCE

# zlib

ZLIB_CFLAGS+=$(shell echo 'zlibbioc::pkgconfig("PKG_CFLAGS")'|\
    "${R_HOME}/bin/R" --vanilla --slave)
SAMTOOLS_CPPFLAGS+=$(ZLIB_CFLAGS)
SAMTOOLS_LIBS+=$(shell echo 'zlibbioc::pkgconfig("PKG_LIBS_shared")' |\
    "${R_HOME}/bin/R" --vanilla --slave)

%.o: %.c
	$(CC) $(ZLIB_CFLAGS) $(ALL_CPPFLAGS) $(ALL_CFLAGS) -c $< -o $@
%.o: %.cc
	$(CXX) $(ZLIB_CFLAGS) $(ALL_CPPFLAGS) $(ALL_CXXFLAGS) -c $< -o $@
%.o: %.cpp
	$(CXX) $(ZLIB_CFLAGS) $(ALL_CPPFLAGS) $(ALL_CXXFLAGS) -c $< -o $@
