## ----setup, include=FALSE--------------------------------------------------
knitr::opts_chunk$set(dpi = 300)
knitr::opts_chunk$set(cache=FALSE)

## ---- echo = FALSE,hide=TRUE, message=FALSE,warning=FALSE------------------
devtools::load_all(".")

## ---- eval = FALSE---------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("StarBioTrek")

## ---- eval = TRUE----------------------------------------------------------
patha<-getKEGGdata(KEGG_path="Transcript")

## ---- eval = TRUE, echo = FALSE--------------------------------------------
knitr::kable(colnames(path), digits = 2,
             caption = "List of patwhays for the group Transcript",row.names = FALSE)

## ---- eval = TRUE----------------------------------------------------------
organism="Saccharomyces_cerevisiae"
netwa<-getNETdata(network="SHpd",organism)

## ---- eval = TRUE----------------------------------------------------------
network_path<-path_net(pathway=path,data=netw)

## ---- eval = TRUE----------------------------------------------------------
list_path<-list_path_net(lista_net=network_path,pathway=path)

## ---- eval = TRUE----------------------------------------------------------
list_path_gene<-GE_matrix(DataMatrix=tumo[,1:2],pathway=path)

## ---- eval = TRUE----------------------------------------------------------
score_mean<-average(dataFilt=tumo[,1:2],pathway=path)

## ---- eval = TRUE----------------------------------------------------------
score_st_dev<-st_dv(DataMatrix=tumo[,1:2],pathway=path)

## ---- eval = TRUE----------------------------------------------------------
score_euc_dista<-euc_dist_crtlk(dataFilt=tumo[,1:2],pathway=path)

## ---- eval = TRUE----------------------------------------------------------
cross_talk_st_dv<-ds_score_crtlk(dataFilt=tumo[,1:2],pathway=path)

## ---- eval = FALSE---------------------------------------------------------
#  nf <- 60
#  res_class<-svm_classification(TCGA_matrix=score_euc_dist[1:2,],nfs=nf,normal=colnames(norm[,1:12]),tumour=colnames(tumo[,1:12]))

## ---- fig.width=6, fig.height=4, echo=FALSE, fig.align="center"------------
library(png)
library(grid)
img <- readPNG("plot_class.png")
grid.raster(img)

## ---- eval = TRUE----------------------------------------------------------
DRIVER_SP<-IPPI(patha=path,netwa=netw)

## ---- fig.width=6, fig.height=4, echo=FALSE, fig.align="center"------------
library(png)
library(grid)
img <- readPNG("plot_path.png")
grid.raster(img)

## ----sessionInfo-----------------------------------------------------------
sessionInfo()

