### R code from vignette source 'metaSeq.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: metaSeq.Rnw:76-77
###################################################
options(width=70)


###################################################
### code chunk number 2: metaSeq.Rnw:124-126
###################################################
library("metaSeq")
library("snow")


###################################################
### code chunk number 3: metaSeq.Rnw:132-133
###################################################
data(BreastCancer)


###################################################
### code chunk number 4: metaSeq.Rnw:139-141
###################################################
flag1 <- c(1,1,1,0,0, 1,0, 1,1,1,1,1,1,1,0, 1,1,0)
flag2 <- c("A","A","A","A","A", "B","B", "C","C","C","C","C","C","C","C", "D","D","D")


###################################################
### code chunk number 5: metaSeq.Rnw:147-148
###################################################
cds <- meta.readData(data = BreastCancer, factor = flag1, studies = flag2)


###################################################
### code chunk number 6: metaSeq.Rnw:154-164
###################################################
## This is very time consuming step.
# cl <- makeCluster(4, "SOCK")
# result <- meta.oneside.noiseq(cds, k = 0.5, norm = "tmm", replicates = "biological",
#  factor = flag1, conditions = c(1, 0), studies = flag2, cl = cl)
# stopCluster(cl)

## Please load pre-calculated result (Result.Meta)
## by data function instead of scripts above.
data(Result.Meta)
result <- Result.Meta


###################################################
### code chunk number 7: metaSeq.Rnw:169-171
###################################################
F <- Fisher.test(result)
S <- Stouffer.test(result)


###################################################
### code chunk number 8: metaSeq.Rnw:177-183
###################################################
head(F$Upper)
head(F$Lower)
F$Weight
head(S$Upper)
head(S$Lower)
S$Weight


###################################################
### code chunk number 9: metaSeq.Rnw:210-217
###################################################
## Assume this matrix as one-sided p-values
## generated by non-NOISeq method (e.g., cuffdiff)
upper <- matrix(runif(300), ncol=3, nrow=100)
lower <- 1 - upper
rownames(upper) <- paste0("Gene", 1:100)
rownames(lower) <- paste0("Gene", 1:100)
weight <- c(3,6,8)


###################################################
### code chunk number 10: metaSeq.Rnw:223-226
###################################################
## other.oneside.pvalues function return a matrix
## which can input Fisher.test or Stouffer.test
result <- other.oneside.pvalues(upper, lower, weight)


###################################################
### code chunk number 11: metaSeq.Rnw:232-243
###################################################
F <- Fisher.test(result)
str(F)
head(F$Upper)
head(F$Lower)
F$Weight

S <- Stouffer.test(result)
str(S)
head(S$Upper)
head(S$Lower)
S$Weight


###################################################
### code chunk number 12: session
###################################################
sessionInfo()


