/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;

public class PrefixMappingAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.PrefixMapping);
        return PrefixMappingAssembler.getPrefixes(a, root, PrefixMapping.Factory.create());
    }

    public static PrefixMapping getPrefixes(Assembler a, Resource root, PrefixMapping result) {
        PrefixMappingAssembler.setSimplePrefixes(root, result);
        PrefixMappingAssembler.includePrefixesFor(a, root, result, JA.includes);
        PrefixMappingAssembler.includePrefixesFor(a, root, result, JA.prefixMapping);
        return result;
    }

    private static void includePrefixesFor(Assembler a, Resource root, PrefixMapping result, Property includeUsing) {
        StmtIterator it = root.listProperties(includeUsing);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            PrefixMapping sub = (PrefixMapping)a.open(PrefixMappingAssembler.getResource(s));
            result.setNsPrefixes(sub);
        }
    }

    private static void setSimplePrefixes(Resource root, PrefixMapping result) {
        if (root.hasProperty(JA.prefix)) {
            Literal prefix = PrefixMappingAssembler.getUniqueLiteral(root, JA.prefix);
            Literal namespace2 = PrefixMappingAssembler.getUniqueLiteral(root, JA.namespace);
            result.setNsPrefix(prefix.getLexicalForm(), namespace2.getLexicalForm());
        }
    }
}

