/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.impl.DBReifierGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.List;

public class DBReifier
implements Reifier {
    protected GraphRDB m_parent = null;
    protected Graph m_hiddenTriples = null;
    protected List m_reifiers = null;
    protected List m_hidden_reifiers = null;
    protected SpecializedGraphReifier m_reifier = null;
    protected ReificationStyle m_style;

    public DBReifier(GraphRDB parent, ReificationStyle style, List allReifiers, List hiddenReifiers) {
        this.m_parent = parent;
        this.m_reifiers = allReifiers;
        this.m_hidden_reifiers = hiddenReifiers;
        this.m_style = style;
        if (this.m_reifiers.size() != 1) {
            throw new BrokenException("Internal error - DBReifier requires exactly one SpecializedGraphReifier");
        }
        this.m_reifier = (SpecializedGraphReifier)this.m_reifiers.get(0);
    }

    public Graph getParentGraph() {
        return this.m_parent;
    }

    public ReificationStyle getStyle() {
        return this.m_style;
    }

    private Graph getReificationTriples() {
        if (this.m_hiddenTriples == null) {
            this.m_hiddenTriples = new DBReifierGraph(this.m_parent, this.m_hidden_reifiers);
        }
        return this.m_hiddenTriples;
    }

    public ExtendedIterator find(TripleMatch m) {
        return this.getReificationTriples().find(m);
    }

    public ExtendedIterator findExposed(TripleMatch m) {
        return this.getReificationTriples().find(m);
    }

    public ExtendedIterator findEither(TripleMatch m, boolean showHidden) {
        return showHidden == this.m_style.conceals() ? this.getReificationTriples().find(m) : NullIterator.instance;
    }

    public int size() {
        return this.m_style.conceals() ? 0 : this.getReificationTriples().size();
    }

    protected static SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    public Node reifyAs(Node n, Triple t) {
        this.m_reifier.add(n, t, DBReifier.newComplete());
        return n;
    }

    public boolean hasTriple(Node n) {
        return this.m_reifier.findReifiedTriple(n, DBReifier.newComplete()) != null;
    }

    public boolean hasTriple(Triple t) {
        return this.m_reifier.findReifiedNodes(t, DBReifier.newComplete()).hasNext();
    }

    public ExtendedIterator allNodes() {
        return this.m_reifier.findReifiedNodes(null, DBReifier.newComplete());
    }

    public ExtendedIterator allNodes(Triple t) {
        return this.m_reifier.findReifiedNodes(t, DBReifier.newComplete());
    }

    public void remove(Node n, Triple t) {
        this.m_reifier.delete(n, t, DBReifier.newComplete());
    }

    public void remove(Triple t) {
        this.m_reifier.delete(null, t, DBReifier.newComplete());
    }

    public boolean handledAdd(Triple t) {
        SpecializedGraph.CompletionFlag complete = DBReifier.newComplete();
        this.m_reifier.add(t, complete);
        return complete.isDone();
    }

    public boolean handledRemove(Triple t) {
        SpecializedGraph.CompletionFlag complete = DBReifier.newComplete();
        this.m_reifier.delete(t, complete);
        return complete.isDone();
    }

    public Triple getTriple(Node n) {
        return this.m_reifier.findReifiedTriple(n, DBReifier.newComplete());
    }

    public void close() {
    }
}

