/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.main.StageGenBasicPattern;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternOptimizer;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Constants;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.List;

public class StageGenOptimizedBasicPattern
implements StageGenerator {
    private StageGenerator other = null;
    private Config config = null;
    private StageGenerator basic = new StageGenBasicPattern();

    public StageGenOptimizedBasicPattern(StageGenerator other, Config config) {
        this.other = other;
        this.config = config;
    }

    public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        Context context = execCxt.getContext();
        Graph graph = execCxt.getActiveGraph();
        if (graph instanceof GraphMemFaster) {
            context.set(Constants.isEnabled, true);
            BasicPatternOptimizer optimizer = new BasicPatternOptimizer(context, graph, pattern, this.config);
            BasicPattern optimized = optimizer.optimize();
            if (!this.isConsistent(pattern, optimized)) {
                throw new ARQException("Optimizer returned an inconsistent pattern: " + pattern + " " + optimized);
            }
            return this.basic.execute(optimized, input, execCxt);
        }
        context.set(Constants.isEnabled, false);
        return this.other.execute(pattern, input, execCxt);
    }

    private boolean isConsistent(BasicPattern pattern, BasicPattern optimized) {
        List optimizedL;
        List patternL = pattern.getList();
        return patternL.containsAll(optimizedL = optimized.getList()) && optimizedL.containsAll(patternL);
    }
}

